/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jdesktop.jxlayer.JXLayer;
import org.mbari.awt.AwtUtilities;
import org.mbari.swing.JImageUrlCanvas;
import vars.annotation.Observation;
import vars.annotation.ui.imagepanel.AbstractJXPainter;
import vars.annotation.ui.imagepanel.IMarkerStyle;

public class JXObservationsPainter<T extends JImageUrlCanvas>
extends AbstractJXPainter<T> {
    private Set<Observation> observations = Collections.synchronizedSet(new HashSet());
    private final boolean drawConceptName;
    private final boolean drawTimecode;
    private IMarkerStyle markerStyle;

    public JXObservationsPainter(IMarkerStyle markerStyle, boolean drawConceptName, boolean drawTimecode) {
        this.markerStyle = markerStyle;
        this.drawTimecode = drawTimecode;
        this.drawConceptName = drawConceptName;
    }

    public IMarkerStyle getMarkerStyle() {
        return this.markerStyle;
    }

    public void setMarkerStyle(IMarkerStyle markerStyle) {
        this.markerStyle = markerStyle;
        this.setDirty(true);
    }

    public Set<Observation> getObservations() {
        return new HashSet<Observation>(this.observations);
    }

    @Override
    public void paintLayer(Graphics2D g2, JXLayer<? extends T> jxl) {
        super.paintLayer(g2, jxl);
        for (Observation observation : this.observations) {
            if (observation.getX() == null || observation.getY() == null) continue;
            Point2D.Double imagePoint = new Point2D.Double(observation.getX(), observation.getY());
            Point2D componentPoint2D = ((JImageUrlCanvas)jxl.getView()).convertToComponent((Point2D)imagePoint);
            if (componentPoint2D == null) continue;
            Point componentPoint = AwtUtilities.toPoint((Point2D)componentPoint2D);
            int x = componentPoint.x;
            int y = componentPoint.y;
            g2.setStroke(this.markerStyle.getStroke());
            g2.setPaint(this.markerStyle.getColor());
            int armLength = this.markerStyle.getArmLength();
            GeneralPath gp = new GeneralPath();
            gp.moveTo(x - armLength, y - armLength);
            gp.lineTo(x + armLength, y + armLength);
            gp.moveTo(x + armLength, y - armLength);
            gp.lineTo(x - armLength, y + armLength);
            g2.draw(gp);
            g2.setFont(this.markerStyle.getFont());
            if (this.drawConceptName) {
                g2.drawString(observation.getConceptName(), x += 5, y);
            }
            if (!this.drawTimecode) continue;
            FontMetrics fontMetrics = g2.getFontMetrics();
            String timecode = observation.getVideoFrame().getTimecode();
            Rectangle2D rect = fontMetrics.getStringBounds(timecode, g2);
            y = (int)((double)y + rect.getHeight() + 5.0);
            g2.drawString(timecode, x, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObservations(Collection<Observation> observations) {
        Set<Observation> set = this.observations;
        synchronized (set) {
            this.observations.clear();
            this.observations.addAll(observations);
        }
        this.setDirty(true);
    }
}

