/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.mbari.swing.JImageUrlCanvas;
import vars.annotation.AnnotationPersistenceService;
import vars.annotation.Association;
import vars.annotation.Observation;
import vars.annotation.VideoArchive;
import vars.annotation.ui.imagepanel.IAFRepaintEvent;
import vars.annotation.ui.imagepanel.JXObservationsPainter;
import vars.annotation.ui.imagepanel.MarkerStyle;
import vars.annotation.ui.imagepanel.UIDataCoordinator;

public class JXIdentityReferencePainter<T extends JImageUrlCanvas>
extends JXObservationsPainter<T> {
    private final Set<Observation> emptySet = new HashSet<Observation>();
    private final AnnotationPersistenceService annotationPersistenceService;
    private Observation observation;

    @Inject
    public JXIdentityReferencePainter(AnnotationPersistenceService annotationPersistenceService) {
        super(MarkerStyle.FAINT, false, true);
        this.annotationPersistenceService = annotationPersistenceService;
        AnnotationProcessor.process((Object)this);
    }

    @EventSubscriber(eventClass=IAFRepaintEvent.class)
    public void respondTo(IAFRepaintEvent event) {
        HashSet<Observation> observations = new HashSet<Observation>(((UIDataCoordinator)event.get()).getSelectedObservations());
        if (observations.size() == 1) {
            this.setObservation((Observation)observations.iterator().next());
        } else {
            this.setObservation(null);
        }
    }

    public void setObservation(Observation observation) {
        if (this.observation != observation) {
            this.observation = observation;
            if (observation != null) {
                Collection associations = Collections2.filter((Collection)observation.getAssociations(), association -> association.getLinkName().equalsIgnoreCase("identity-reference"));
                if (!associations.isEmpty()) {
                    Association identityAss = (Association)associations.iterator().next();
                    int id = Integer.parseInt(identityAss.getLinkValue());
                    String conceptName = observation.getConceptName();
                    VideoArchive videoArchive = observation.getVideoFrame().getVideoArchive();
                    Collection relatedObservations = this.annotationPersistenceService.findAllObservationsByNameAndReferenceNumber(videoArchive, conceptName, id);
                    relatedObservations.remove(observation);
                    this.setObservations(relatedObservations);
                } else {
                    this.setObservations(this.emptySet);
                }
            } else {
                this.setObservations(this.emptySet);
            }
            this.setDirty(true);
        }
    }
}

