/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.swing.DynamicList;
import org.mbari.swing.ListListModel;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.imagepanel.JXHorizontalLinePainter;
import vars.shared.ui.dialogs.StandardDialog;

public class JXHorizontalLinePainterDialog
extends StandardDialog {
    private Status status;
    private JScrollPane scrollPane;
    private DynamicList list;
    private final JXHorizontalLinePainter painter;

    public JXHorizontalLinePainterDialog(JXHorizontalLinePainter painter) {
        this(StateLookup.getAnnotationFrame(), painter);
    }

    public JXHorizontalLinePainterDialog(Frame parent, JXHorizontalLinePainter painter) {
        super(parent);
        try {
            this.initialize();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.status = Status.Cancel;
        this.setTitle("Add Horizontal Lines (0 < percent < 1)");
        this.painter = painter;
    }

    private void initialize() throws Exception {
        this.getContentPane().add((Component)this.getScrollPane(), "Center");
        this.getOkayButton().addActionListener((ActionListener)new ActionAdapter(){

            public void doAction() {
                ListModel model = JXHorizontalLinePainterDialog.this.getList().getModel();
                ArrayList<Double> distances = new ArrayList<Double>();
                for (int i = 0; i < model.getSize(); ++i) {
                    String s = (String)model.getElementAt(i);
                    try {
                        double d = Double.parseDouble(s);
                        distances.add(d);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                JXHorizontalLinePainterDialog.this.painter.setDistances(distances);
                JXHorizontalLinePainterDialog.this.cleanupList();
                JXHorizontalLinePainterDialog.this.setVisible(false);
            }
        });
        this.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JXHorizontalLinePainterDialog.this.cleanupList();
                JXHorizontalLinePainterDialog.this.setVisible(false);
            }
        });
    }

    private void cleanupList() {
        ArrayList<Double> distances = new ArrayList<Double>(this.painter.getDistances());
        Collections.sort(distances);
        ListListModel model = this.getList().getContent();
        model.clear();
        for (Double d : distances) {
            model.add((Object)d.toString());
        }
    }

    public Status getStatus() {
        return this.status;
    }

    protected DynamicList getList() {
        if (this.list == null) {
            this.list = new DynamicList("0.");
            this.list.setBorder((Border)new TitledBorder("Enter to add, backspace to remove"));
        }
        return this.list;
    }

    protected JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane((Component)this.getList());
            this.scrollPane.setViewportBorder(new TitledBorder(null, "Horizontal Lines as percent", 4, 2, null, null));
            this.scrollPane.setVerticalScrollBarPolicy(22);
        }
        return this.scrollPane;
    }

    public static enum Status {
        OK,
        Cancel;

    }
}

