/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import org.jdesktop.jxlayer.JXLayer;
import org.mbari.swing.JImageCanvas;
import vars.annotation.ui.imagepanel.AbstractJXPainter;

public class JXHorizontalLinePainter<A extends JComponent>
extends AbstractJXPainter<A> {
    private Stroke stroke = new BasicStroke(2.0f);
    private Collection<HorizontalLine> horizontalLines = new ArrayList<HorizontalLine>();
    private final JImageCanvas imageCanvas;

    public JXHorizontalLinePainter(JImageCanvas imageCanvas) {
        this.imageCanvas = imageCanvas;
    }

    public Collection<Double> getDistances() {
        ArrayList<Double> distances = new ArrayList<Double>(this.horizontalLines.size());
        for (HorizontalLine p : this.horizontalLines) {
            distances.add(p.percent);
        }
        return distances;
    }

    public void setDistances(Collection<Double> distances) {
        this.horizontalLines.clear();
        for (Double d : distances) {
            this.horizontalLines.add(new HorizontalLine(d));
        }
        this.setDirty(true);
    }

    @Override
    public void paintLayer(Graphics2D g2, JXLayer<? extends A> jxl) {
        g2.setStroke(this.stroke);
        g2.setPaint(Color.MAGENTA);
        int w = jxl.getWidth();
        int h = jxl.getHeight();
        for (HorizontalLine line : this.horizontalLines) {
            line.update(w);
            g2.draw(line.path);
        }
        g2.setPaintMode();
    }

    class HorizontalLine {
        final GeneralPath path = new GeneralPath();
        final double percent;

        HorizontalLine(double percent) {
            this.percent = percent;
        }

        void update(int w) {
            double iy = (double)JXHorizontalLinePainter.this.imageCanvas.getImageHeight() * this.percent;
            Point2D cp = JXHorizontalLinePainter.this.imageCanvas.convertToComponent((Point2D)new Point2D.Double(0.0, iy));
            this.path.reset();
            double y = cp.getY();
            this.path.moveTo(0.0, y);
            this.path.lineTo((double)w, y);
        }
    }
}

