/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import Jama.Matrix;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdesktop.jxlayer.JXLayer;
import org.mbari.geometry.Point2D;
import vars.annotation.ui.imagepanel.AbstractJXPainter;

public class JXGridPainter<A extends JComponent>
extends AbstractJXPainter<A> {
    private double angle;
    private int centerX;
    private int centerY;
    private double pixelDistance;
    private int pixelHeight;
    private int pixelWidth;

    private List<GeneralPath> buildLines() {
        int numberOfLinesX = (int)Math.floor((double)this.pixelWidth / this.pixelDistance);
        double[] xx = new double[numberOfLinesX];
        for (int i = 0; i < numberOfLinesX; ++i) {
            xx[i] = this.pixelDistance * (double)i;
        }
        int numberOfLinesY = (int)Math.floor((double)this.pixelHeight / this.pixelDistance);
        double[] yy = new double[numberOfLinesY];
        for (int i = 0; i < numberOfLinesY; ++i) {
            yy[i] = this.pixelDistance * (double)i;
        }
        Matrix rotMat = new Matrix((double[][])new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, Math.cos(this.angle), -Math.sin(this.angle), 0.0}, {0.0, Math.sin(this.angle), Math.cos(this.angle), 0.0}, {0.0, 0.0, 0.0, 1.0}});
        Matrix topX = new Matrix((double[][])new double[][]{xx, this.narray(xx.length, 0.0), this.narray(xx.length, 0.0), this.narray(xx.length, 1.0)});
        Matrix virtualTopX = rotMat.times(topX);
        Matrix bottomX = new Matrix((double[][])new double[][]{xx, this.narray(xx.length, this.pixelHeight), this.narray(xx.length, 0.0), this.narray(xx.length, 1.0)});
        Matrix virtualBottomX = rotMat.times(bottomX);
        ArrayList<GeneralPath> lines = new ArrayList<GeneralPath>();
        GeneralPath line = new GeneralPath();
        for (int i = 0; i < numberOfLinesX; ++i) {
            double xtop = virtualTopX.get(0, i);
            double ytop = virtualTopX.get(1, i);
            double xbottom = virtualBottomX.get(0, i);
            double ybottom = virtualBottomX.get(1, i);
            line.moveTo(xtop, ytop);
            line.lineTo(xbottom, ybottom);
        }
        lines.add(line);
        return lines;
    }

    public void calculateCenter() {
        this.centerX = this.pixelWidth / 2;
        this.centerY = this.pixelHeight / 2;
    }

    private double[] narray(int n, double value) {
        double[] v = new double[n];
        for (int i = 0; i < n; ++i) {
            v[i] = value;
        }
        return v;
    }

    @Override
    public void paintLayer(Graphics2D g2, JXLayer<? extends A> jxl) {
        g2.setStroke(new BasicStroke(2.0f));
        g2.setPaint(Color.WHITE);
        List<GeneralPath> lines = this.buildLines();
        for (GeneralPath line : lines) {
            g2.draw(line);
        }
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public void setPixelDistance(double pixelDistance) {
        this.pixelDistance = pixelDistance;
    }

    public void setPixelHeight(int pixelHeight) {
        this.pixelHeight = pixelHeight;
        this.calculateCenter();
    }

    public void setPixelWidth(int pixelWidth) {
        this.pixelWidth = pixelWidth;
        this.calculateCenter();
    }

    private class PointPair {
        Point2D p1;
        Point2D p2;

        private PointPair() {
        }
    }
}

