/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdesktop.jxlayer.JXLayer;
import vars.annotation.ui.imagepanel.AbstractJXPainter;

public class JXCrossHairPainter<A extends JComponent>
extends AbstractJXPainter<A> {
    private GeneralPath crosshair = new GeneralPath();
    private final Stroke stroke = new BasicStroke(1.0f);

    @Override
    public void paintLayer(Graphics2D gd, JXLayer<? extends A> jxl) {
        gd.setStroke(this.stroke);
        gd.setPaint(Color.GRAY);
        gd.setXORMode(Color.WHITE);
        gd.draw(this.crosshair);
        gd.setPaintMode();
    }

    @Override
    public void processMouseMotionEvent(MouseEvent me, JXLayer jxl) {
        if (me.getID() == 503 || me.getID() == 506) {
            Point point = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), (Component)jxl);
            int w = jxl.getWidth();
            int h = jxl.getHeight();
            this.crosshair.reset();
            if (point.y <= h) {
                this.crosshair.moveTo(0.0f, point.y);
                this.crosshair.lineTo(w, point.y);
            }
            if (point.x <= w) {
                this.crosshair.moveTo(point.x, 0.0f);
                this.crosshair.lineTo(point.x, h);
            }
            this.setDirty(true);
        }
    }
}

