/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdesktop.jxlayer.JXLayer;
import org.mbari.geometry.Point2D;
import org.mbari.swing.JImageUrlCanvas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ILink;
import vars.annotation.AreaMeasurement;
import vars.annotation.Association;
import vars.annotation.ui.imagepanel.AbstractJXPainter;

public class JXAreaMeasurementPainter<T extends JImageUrlCanvas>
extends AbstractJXPainter<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Function<ILink, AreaMeasurementPath> associationTransform = new Function<ILink, AreaMeasurementPath>(){

        public AreaMeasurementPath apply(ILink input) {
            return new AreaMeasurementPath((AreaMeasurement)AreaMeasurement.LINK_TO_AREA_MEASUREMENT_TRANSFORM.apply(input));
        }
    };
    private final Collection<AreaMeasurementPath> areaMeasurementPaths = new CopyOnWriteArrayList<AreaMeasurementPath>();
    private final Font lineFont;
    private Color paint;
    private final Stroke stroke;

    public JXAreaMeasurementPainter() {
        this(new Font("Sans Serif", 0, 10), Color.GREEN, new BasicStroke(2.0f));
    }

    public JXAreaMeasurementPainter(Font font, Color paint, Stroke stroke) {
        this.lineFont = font;
        this.paint = paint;
        this.stroke = stroke;
    }

    @Override
    public void paintLayer(Graphics2D g2, JXLayer<? extends T> jxl) {
        super.paintLayer(g2, jxl);
        g2.setPaint(this.paint);
        g2.setStroke(this.stroke);
        for (AreaMeasurementPath path : this.areaMeasurementPaths) {
            try {
                this.updateAreaMeasurementPath(path, jxl);
                String comment = path.areaMeasurement.getComment();
                g2.draw(path.generalPath);
                g2.setFont(this.lineFont);
                if (Strings.isNullOrEmpty((String)comment)) continue;
                g2.drawString(comment, (float)path.commentPoint.getX(), (float)path.commentPoint.getY());
            }
            catch (Exception e) {
                this.log.warn("Problem with drawing area measurement path", (Throwable)e);
            }
        }
    }

    public void setAssociations(Collection<Association> associations) {
        this.areaMeasurementPaths.clear();
        associations.stream().filter(AreaMeasurement.IS_AREA_MEASUREMENT_PREDICATE).map(arg_0 -> this.associationTransform.apply(arg_0)).forEach(this.areaMeasurementPaths::add);
    }

    private void updateAreaMeasurementPath(AreaMeasurementPath areaMeasurementPath, JXLayer<? extends T> jxl) {
        AreaMeasurement areaMeasurement = areaMeasurementPath.areaMeasurement;
        GeneralPath generalPath = areaMeasurementPath.generalPath;
        generalPath.reset();
        List coordinates = areaMeasurement.getCoordinates();
        double sumX = 0.0;
        double sumY = 0.0;
        for (int i = 0; i < coordinates.size(); ++i) {
            Point2D coordinate = (Point2D)coordinates.get(i);
            Point2D.Double imagePoint = new Point2D.Double(((Integer)coordinate.getX()).intValue(), ((Integer)coordinate.getY()).intValue());
            java.awt.geom.Point2D componentPoint = ((JImageUrlCanvas)jxl.getView()).convertToComponent((java.awt.geom.Point2D)imagePoint);
            if (i == 0) {
                generalPath.moveTo(componentPoint.getX(), componentPoint.getY());
            } else {
                generalPath.lineTo(componentPoint.getX(), componentPoint.getY());
            }
            sumX += componentPoint.getX();
            sumY += componentPoint.getY();
        }
        Point2D coordinate = (Point2D)coordinates.get(0);
        Point2D.Double imagePoint = new Point2D.Double(((Integer)coordinate.getX()).intValue(), ((Integer)coordinate.getY()).intValue());
        java.awt.geom.Point2D componentPoint = ((JImageUrlCanvas)jxl.getView()).convertToComponent((java.awt.geom.Point2D)imagePoint);
        generalPath.lineTo(componentPoint.getX(), componentPoint.getY());
        double cx = sumX / (double)coordinates.size() + 5.0;
        double cy = sumY / (double)coordinates.size();
        areaMeasurementPath.commentPoint.setLocation(cx, cy);
    }

    public Color getPaint() {
        return this.paint;
    }

    public void setPaint(Color paint) {
        this.paint = paint;
    }

    class AreaMeasurementPath {
        final GeneralPath generalPath = new GeneralPath();
        final java.awt.geom.Point2D commentPoint = new Point2D.Float();
        final AreaMeasurement areaMeasurement;

        AreaMeasurementPath(AreaMeasurement areaMeasurement) {
            this.areaMeasurement = areaMeasurement;
        }
    }
}

