/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import com.google.common.collect.ImmutableList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JFrame;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import vars.annotation.AreaMeasurement;
import vars.annotation.Observation;
import vars.annotation.VideoFrame;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.impl.AddAssociationCmd;
import vars.annotation.ui.imagepanel.AddAreaMeasurementEvent;
import vars.annotation.ui.imagepanel.Measurement;
import vars.annotation.ui.imagepanel.MeasurementCommentDialog;
import vars.annotation.ui.imagepanel.MeasurementCompletedEvent;
import vars.annotation.ui.imagepanel.MeasurementCompletedListener;

public class ImageAnnotationFrameController
implements MeasurementCompletedListener {
    private final AddMeasurementAction measurementAction = new AddMeasurementAction();
    private AddAreaMeasurementEvent addAreaMeasurementEvent;
    private MeasurementCommentDialog areaMeasurementDialog;
    private final JFrame imageAnnotationFrame;
    private MeasurementCommentDialog measurementDialog;
    private final ToolBelt toolBelt;
    private VideoFrame videoFrame;

    public ImageAnnotationFrameController(ToolBelt toolBelt, JFrame imageAnnotationFrame) {
        this.toolBelt = toolBelt;
        this.imageAnnotationFrame = imageAnnotationFrame;
        AnnotationProcessor.process((Object)this);
    }

    private MeasurementCommentDialog getAreaMeasurementCommentDialog() {
        if (this.areaMeasurementDialog == null) {
            this.areaMeasurementDialog = new MeasurementCommentDialog(this.imageAnnotationFrame);
            this.areaMeasurementDialog.getOkayButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ImageAnnotationFrameController.this.addAreaMeasurementEvent != null) {
                        AreaMeasurement areaMeasurement = ImageAnnotationFrameController.this.addAreaMeasurementEvent.getAreaMeasurement();
                        Observation observation = ImageAnnotationFrameController.this.addAreaMeasurementEvent.getObservation();
                        ImageAnnotationFrameController.this.addAreaMeasurementEvent = null;
                        areaMeasurement.setComment(ImageAnnotationFrameController.this.areaMeasurementDialog.getComment());
                        AddAssociationCmd command = new AddAssociationCmd(areaMeasurement.toLink(), (Collection<Observation>)ImmutableList.of((Object)observation));
                        CommandEvent commandEvent = new CommandEvent(command);
                        EventBus.publish((Object)commandEvent);
                    }
                    ImageAnnotationFrameController.this.areaMeasurementDialog.setVisible(false);
                }
            });
        }
        return this.areaMeasurementDialog;
    }

    private MeasurementCommentDialog getMeasurementCommentDialog() {
        if (this.measurementDialog == null) {
            this.measurementDialog = new MeasurementCommentDialog(this.imageAnnotationFrame);
            this.measurementDialog.getOkayButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageAnnotationFrameController.this.measurementAction.setComment(ImageAnnotationFrameController.this.measurementDialog.getComment());
                    ImageAnnotationFrameController.this.measurementDialog.setVisible(false);
                    ImageAnnotationFrameController.this.measurementAction.apply();
                }
            });
        }
        return this.measurementDialog;
    }

    public ToolBelt getToolBelt() {
        return this.toolBelt;
    }

    public VideoFrame getVideoFrame() {
        return this.videoFrame;
    }

    @Override
    public void onComplete(MeasurementCompletedEvent event) {
        this.measurementAction.setMeasurement(event.getMeasurement());
        this.measurementAction.setObservation(event.getObservation());
        this.getMeasurementCommentDialog().setVisible(true);
    }

    @EventSubscriber(eventClass=AddAreaMeasurementEvent.class)
    public void respondTo(AddAreaMeasurementEvent event) {
        this.addAreaMeasurementEvent = event;
        this.getAreaMeasurementCommentDialog().setVisible(true);
    }

    public void setVideoFrame(VideoFrame videoFrame) {
        this.videoFrame = videoFrame;
    }

    private class AddMeasurementAction {
        private String comment;
        private Measurement measurement;
        private Observation observation;

        private AddMeasurementAction() {
        }

        public void apply() {
            if (this.measurement != null && this.observation != null) {
                this.measurement.setComment(this.comment);
                AddAssociationCmd command = new AddAssociationCmd(this.measurement.toLink(), (Collection<Observation>)ImmutableList.of((Object)this.observation));
                CommandEvent commandEvent = new CommandEvent(command);
                EventBus.publish((Object)commandEvent);
            }
        }

        void setComment(String comment) {
            this.comment = comment;
        }

        void setMeasurement(Measurement measurement) {
            this.measurement = measurement;
        }

        void setObservation(Observation observation) {
            this.observation = observation;
        }
    }
}

