/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.mbari.awt.image.ImageUtilities;
import org.mbari.swing.JImageCanvas;
import org.mbari.swing.JImageUrlCanvas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.VideoFrame;
import vars.annotation.ui.AnnotationImageCanvas;
import vars.annotation.ui.PersistenceController;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.eventbus.ObservationsSelectedEvent;
import vars.annotation.ui.eventbus.VideoFramesChangedEvent;
import vars.annotation.ui.imagepanel.AnnotationLayerUI;
import vars.annotation.ui.imagepanel.AreaMeasurementLayerUI2;
import vars.annotation.ui.imagepanel.CommonPainters;
import vars.annotation.ui.imagepanel.ImageAnnotationFrameController;
import vars.annotation.ui.imagepanel.ImageFrameLayerUI;
import vars.annotation.ui.imagepanel.JXCrossHairPainter;
import vars.annotation.ui.imagepanel.JXHorizontalLinePainter;
import vars.annotation.ui.imagepanel.MeasurementLayerUI;
import vars.annotation.ui.imagepanel.UIDataCoordinator;
import vars.knowledgebase.Concept;
import vars.shared.ui.AllConceptNamesComboBox;
import vars.shared.ui.ConceptNameComboBox;

public class ImageAnnotationFrame
extends JFrame {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ButtonGroup layersButtonGroup = new ButtonGroup();
    private final List<ImageFrameLayerUI<JImageUrlCanvas>> layers = new ArrayList<ImageFrameLayerUI<JImageUrlCanvas>>();
    private final PropertyChangeListener imageChangeListener = evt -> {
        Image image = (Image)evt.getNewValue();
        BufferedImage bufferedImage = ImageUtilities.toBufferedImage((Image)image);
        this.getMeasurementLayerUI().setImage(bufferedImage);
        this.getAreaMeasurementLayerUI().setImage(bufferedImage);
    };
    private AnnotationLayerUI annotationLayerUI;
    private AreaMeasurementLayerUI2<JImageUrlCanvas> areaMeasurementLayerUI;
    private ConceptNameComboBox comboBox;
    private final ImageAnnotationFrameController controller;
    private final UIDataCoordinator dataCoordinator;
    private JImageUrlCanvas imageCanvas;
    private JXLayer<JImageUrlCanvas> layer;
    private MeasurementLayerUI<JImageUrlCanvas> measurementLayerUI;
    private JPanel settingsPanel;
    private JToolBar toolBar;
    private CommonPainters<JImageUrlCanvas> commonPainters;
    private JLabel pixelLabel;

    public ImageAnnotationFrame(ToolBelt toolBelt) {
        this.controller = new ImageAnnotationFrameController(toolBelt, this);
        this.dataCoordinator = new UIDataCoordinator(toolBelt.getAnnotationDAOFactory());
        this.layers.add(this.getAnnotationLayerUI());
        this.layers.add(this.getMeasurementLayerUI());
        this.layers.add(this.getAreaMeasurementLayerUI());
        AnnotationProcessor.process((Object)this);
        this.initialize();
    }

    private CommonPainters<JImageUrlCanvas> getCommonPainters() {
        if (this.commonPainters == null) {
            this.commonPainters = new CommonPainters(new JXHorizontalLinePainter((JImageCanvas)this.getImageCanvas()), new JXCrossHairPainter());
        }
        return this.commonPainters;
    }

    protected AnnotationLayerUI getAnnotationLayerUI() {
        if (this.annotationLayerUI == null) {
            this.annotationLayerUI = new AnnotationLayerUI<JImageUrlCanvas>(this.controller.getToolBelt(), this.dataCoordinator, this.getCommonPainters());
        }
        return this.annotationLayerUI;
    }

    protected AreaMeasurementLayerUI2<JImageUrlCanvas> getAreaMeasurementLayerUI() {
        if (this.areaMeasurementLayerUI == null) {
            this.areaMeasurementLayerUI = new AreaMeasurementLayerUI2<JImageUrlCanvas>(this.controller.getToolBelt(), (JImageCanvas)this.getImageCanvas(), this.getCommonPainters());
        }
        return this.areaMeasurementLayerUI;
    }

    protected ConceptNameComboBox getComboBox() {
        if (this.comboBox == null) {
            ToolBelt toolBelt = this.controller.getToolBelt();
            this.comboBox = new AllConceptNamesComboBox(toolBelt.getQueryPersistenceService());
            this.comboBox.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    Concept concept = toolBelt.getAnnotationPersistenceService().findConceptByName((String)this.comboBox.getSelectedItem());
                    this.log.debug("Using concept: " + concept.getPrimaryConceptName().getName());
                    this.getAnnotationLayerUI().setConcept(concept);
                }
            });
        }
        return this.comboBox;
    }

    protected JImageUrlCanvas getImageCanvas() {
        if (this.imageCanvas == null) {
            this.imageCanvas = new AnnotationImageCanvas();
            this.imageCanvas.addPropertyChangeListener("image", this.imageChangeListener);
        }
        return this.imageCanvas;
    }

    protected JXLayer<JImageUrlCanvas> getLayer() {
        if (this.layer == null) {
            this.layer = new JXLayer((Component)this.getImageCanvas());
            this.layer.setUI((LayerUI)this.layers.get(0));
            this.setSettingsPanel(this.layers.get(0).getSettingsBuilder().getPanel());
        }
        return this.layer;
    }

    protected MeasurementLayerUI<JImageUrlCanvas> getMeasurementLayerUI() {
        if (this.measurementLayerUI == null) {
            this.measurementLayerUI = new MeasurementLayerUI<JImageUrlCanvas>(this.controller.getToolBelt(), this.getCommonPainters());
            this.measurementLayerUI.addMeasurementCompletedListener(this.controller);
        }
        return this.measurementLayerUI;
    }

    protected JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.add(this.getPixelLabel());
            this.toolBar.add((Component)this.getComboBox());
            for (int i = 0; i < this.layers.size(); ++i) {
                int j = i;
                ImageFrameLayerUI<JImageUrlCanvas> layerUI = this.layers.get(i);
                JRadioButton button = new JRadioButton(layerUI.getDisplayName());
                button.addActionListener(e -> {
                    ((ImageFrameLayerUI)this.getLayer().getUI()).resetUI();
                    this.getLayer().setUI((LayerUI)this.layers.get(j));
                    this.setSettingsPanel(this.layers.get(j).getSettingsBuilder().getPanel());
                });
                if (j == 0) {
                    button.setSelected(true);
                }
                this.toolBar.add(button);
                this.layersButtonGroup.add(button);
            }
        }
        return this.toolBar;
    }

    public JLabel getPixelLabel() {
        if (this.pixelLabel == null) {
            this.pixelLabel = new JLabel("    ,     ");
            this.pixelLabel.setPreferredSize(new Dimension(200, 35));
            JImageUrlCanvas ic = this.getImageCanvas();
            ic.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter((JImageCanvas)ic){
                final /* synthetic */ JImageCanvas val$ic;
                {
                    this.val$ic = jImageCanvas;
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    Point cp = e.getPoint();
                    Point2D ip = this.val$ic.convertToImage((Point2D)cp);
                    String text = String.format("%4d, %4d", Math.round(ip.getX()), Math.round(ip.getY()));
                    ImageAnnotationFrame.this.pixelLabel.setText("Current X, Y: " + text);
                }
            });
        }
        return this.pixelLabel;
    }

    public VideoFrame getVideoFrame() {
        return this.controller.getVideoFrame();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getLayer(), "Center");
        this.add((Component)this.getToolBar(), "South");
        this.setPreferredSize(new Dimension(640, 480));
        this.getImageCanvas().setUrl(null);
    }

    @EventSubscriber(eventClass=ObservationsSelectedEvent.class)
    public void respondTo(ObservationsSelectedEvent selectionEvent) {
        if (selectionEvent.getSelectionSource() != this && !((Object)((Object)this.getAnnotationLayerUI())).equals(selectionEvent.getSelectionSource())) {
            Set<VideoFrame> videoFrames = PersistenceController.toVideoFrames((Collection)selectionEvent.get());
            if (videoFrames.size() == 1) {
                VideoFrame videoFrame = videoFrames.iterator().next();
                this.setVideoFrame(videoFrame);
            } else {
                this.setVideoFrame(null);
            }
        }
    }

    @EventSubscriber(eventClass=VideoFramesChangedEvent.class)
    public void respondTo(VideoFramesChangedEvent event) {
        ArrayList videoFrames;
        int idx;
        if (((Collection)event.get()).contains(this.controller.getVideoFrame()) && (idx = (videoFrames = new ArrayList((Collection)event.get())).indexOf(this.controller.getVideoFrame())) > -1) {
            this.setVideoFrame((VideoFrame)videoFrames.get(idx));
        }
    }

    private void setSettingsPanel(JPanel panel) {
        if (this.settingsPanel != null) {
            this.remove(this.settingsPanel);
        }
        this.settingsPanel = panel;
        this.add((Component)this.settingsPanel, "North");
        this.validate();
        this.repaint();
    }

    private void setVideoFrame(VideoFrame videoFrame) {
        this.controller.setVideoFrame(videoFrame);
        URL imageReference = null;
        try {
            imageReference = new URL(videoFrame.getCameraData().getImageReference());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getImageCanvas().setUrl(imageReference);
    }
}

