/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.swing.JComponent;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import vars.annotation.ui.imagepanel.HorizontalLinesChangedEvent;
import vars.annotation.ui.imagepanel.JXCrossHairPainter;
import vars.annotation.ui.imagepanel.JXHorizontalLinePainter;
import vars.annotation.ui.imagepanel.JXPainter;

public class CommonPainters<A extends JComponent> {
    private final JXHorizontalLinePainter<A> horizontalLinePainter;
    private final JXCrossHairPainter<A> crossHairPainter;

    public CommonPainters(JXHorizontalLinePainter<A> horizontalLinePainter, JXCrossHairPainter<A> crossHairPainter) {
        Preconditions.checkNotNull(horizontalLinePainter, (Object)"The horizontalLinePainter reference can not be null");
        Preconditions.checkNotNull(crossHairPainter, (Object)"The crossHairPainter reference can not be null");
        this.horizontalLinePainter = horizontalLinePainter;
        this.crossHairPainter = crossHairPainter;
        AnnotationProcessor.process((Object)this);
    }

    public Collection<? extends JXPainter<A>> getPainters() {
        return ImmutableList.of(this.horizontalLinePainter, this.crossHairPainter);
    }

    public JXHorizontalLinePainter<A> getHorizontalLinePainter() {
        return this.horizontalLinePainter;
    }

    public JXCrossHairPainter<A> getCrossHairPainter() {
        return this.crossHairPainter;
    }

    public void respondTo(HorizontalLinesChangedEvent event) {
        this.horizontalLinePainter.setDistances(event.getDistances());
    }
}

