/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jdesktop.jxlayer.JXLayer;
import org.mbari.awt.AwtUtilities;
import org.mbari.geometry.Point2D;
import org.mbari.swing.JImageCanvas;
import org.mbari.swing.JImageUrlCanvas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ToolBelt;
import vars.annotation.AreaMeasurement;
import vars.annotation.Observation;
import vars.annotation.ui.imagepanel.AddAreaMeasurementEvent;
import vars.annotation.ui.imagepanel.AreaMeasurementLayerSettingsBuilder;
import vars.annotation.ui.imagepanel.CommonPainters;
import vars.annotation.ui.imagepanel.IAFRepaintEvent;
import vars.annotation.ui.imagepanel.ImageFrameLayerUI;
import vars.annotation.ui.imagepanel.JXHorizontalLinePainter;
import vars.annotation.ui.imagepanel.JXNotSelectedObservationsPainter;
import vars.annotation.ui.imagepanel.JXPainter;
import vars.annotation.ui.imagepanel.JXSelectedAreaMeasurementPainter;
import vars.annotation.ui.imagepanel.JXSelectedObservationsPainter;
import vars.annotation.ui.imagepanel.MarkerStyle;
import vars.annotation.ui.imagepanel.UIDataCoordinator;

public class AreaMeasurementLayerUI2<T extends JImageUrlCanvas>
extends ImageFrameLayerUI<T> {
    private static final int markerDiameter = 10;
    private JXPainter<T> notSelectedObservationsPainter = new JXNotSelectedObservationsPainter(MarkerStyle.FAINT);
    private JXPainter<T> selectedObservationsPainter = new JXSelectedObservationsPainter(MarkerStyle.NOTSELECTED);
    private JXPainter<T> selectedAreaMeasurementPainter = new JXSelectedAreaMeasurementPainter<T>();
    private JXHorizontalLinePainter<T> horizontalLinePainter;
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private List<Point2D<Integer>> pointsIC = new CopyOnWriteArrayList<Point2D<Integer>>();
    private GeneralPath polygonCC = new GeneralPath();
    private java.awt.geom.Point2D currentPointCC = new Point2D.Double();
    private GeneralPath bridgeCC = new GeneralPath();
    private final Runnable resetRunable = new Runnable(){

        @Override
        public void run() {
            AreaMeasurementLayerUI2.this.polygonCC.reset();
            AreaMeasurementLayerUI2.this.bridgeCC.reset();
            AreaMeasurementLayerUI2.this.pointsIC.clear();
            AreaMeasurementLayerUI2.this.setDirty(true);
        }
    };
    private BufferedImage image;
    private Observation observation;
    private final ToolBelt toolBelt;

    public AreaMeasurementLayerUI2(ToolBelt toolBelt, JImageCanvas imageCanvas, CommonPainters<T> commonPainters) {
        super(commonPainters);
        this.horizontalLinePainter = commonPainters.getHorizontalLinePainter();
        this.setDisplayName("Area");
        this.setSettingsBuilder(new AreaMeasurementLayerSettingsBuilder(this));
        this.toolBelt = toolBelt;
        AnnotationProcessor.process((Object)((Object)this));
        this.setObservation(null);
        this.addPainter(this.notSelectedObservationsPainter);
        this.addPainter(this.selectedObservationsPainter);
        this.addPainter(this.selectedAreaMeasurementPainter);
    }

    @Override
    public void clearPainters() {
        super.clearPainters();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    private AreaMeasurement newAreaMeasurement(String comment) {
        return new AreaMeasurement(new ArrayList<Point2D<Integer>>(this.pointsIC), comment);
    }

    @Override
    protected void paintLayer(Graphics2D g2, JXLayer<? extends T> jxl) {
        super.paintLayer(g2, jxl);
        g2.setPaintMode();
        if (this.observation != null) {
            this.polygonCC.reset();
            if (this.pointsIC.size() > 0) {
                Color color = this.pointsIC.size() < 3 ? Color.RED : Color.CYAN;
                g2.setStroke(new BasicStroke(2.0f));
                g2.setPaint(color);
                for (int i = 0; i < this.pointsIC.size(); ++i) {
                    Point2D<Integer> coordinate = this.pointsIC.get(i);
                    Point2D.Double imagePoint = new Point2D.Double(((Integer)coordinate.getX()).intValue(), ((Integer)coordinate.getY()).intValue());
                    java.awt.geom.Point2D componentPoint = ((JImageUrlCanvas)jxl.getView()).convertToComponent((java.awt.geom.Point2D)imagePoint);
                    if (i == 0) {
                        this.polygonCC.moveTo(componentPoint.getX(), componentPoint.getY());
                        continue;
                    }
                    this.polygonCC.lineTo(componentPoint.getX(), componentPoint.getY());
                    this.polygonCC.moveTo(componentPoint.getX(), componentPoint.getY());
                }
                Point2D<Integer> coordinate = this.pointsIC.get(0);
                Point2D.Double imagePoint = new Point2D.Double(((Integer)coordinate.getX()).intValue(), ((Integer)coordinate.getY()).intValue());
                java.awt.geom.Point2D componentPoint = ((JImageUrlCanvas)jxl.getView()).convertToComponent((java.awt.geom.Point2D)imagePoint);
                this.polygonCC.lineTo(componentPoint.getX(), componentPoint.getY());
                g2.draw(this.polygonCC);
                int markerOffset = 5;
                if (this.pointsIC.size() > 1) {
                    g2.setPaint(Color.RED);
                    g2.draw(this.bridgeCC);
                    Point p = AwtUtilities.toPoint((java.awt.geom.Point2D)this.currentPointCC);
                    Ellipse2D.Double marker = new Ellipse2D.Double(p.x - 5, p.y - 5, 10.0, 10.0);
                    g2.draw(marker);
                }
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent me, JXLayer<? extends T> jxl) {
        super.processMouseEvent(me, jxl);
        Point point = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), jxl);
        switch (me.getID()) {
            case 501: {
                java.awt.geom.Point2D imagePoint = ((JImageUrlCanvas)jxl.getView()).convertToImage((java.awt.geom.Point2D)point);
                int x = (int)Math.round(imagePoint.getX());
                int y = (int)Math.round(imagePoint.getY());
                if (me.getClickCount() == 1 && me.getButton() == 1) {
                    if (this.image == null) break;
                    if (x < 0) {
                        x = 0;
                    }
                    if (x > this.image.getWidth()) {
                        x = this.image.getWidth();
                    }
                    if (y < 0) {
                        y = 0;
                    }
                    if (y > this.image.getHeight()) {
                        y = this.image.getHeight();
                    }
                    this.pointsIC.add((Point2D<Integer>)new Point2D((Number)x, (Number)y));
                    this.setDirty(true);
                    break;
                }
                if (me.getClickCount() != 2 && me.getButton() == 1) break;
                if (this.pointsIC.size() > 2 && this.observation != null) {
                    AreaMeasurement areaMeasurement = this.newAreaMeasurement(null);
                    AddAreaMeasurementEvent event = new AddAreaMeasurementEvent(this.observation, areaMeasurement);
                    EventBus.publish((Object)event);
                }
                this.resetUI();
                this.setObservation(this.observation);
            }
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent me, JXLayer<? extends T> jxl) {
        super.processMouseMotionEvent(me, jxl);
        if (me.getID() == 503 && this.pointsIC.size() > 1) {
            Point point = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), jxl);
            this.currentPointCC.setLocation(point.getX(), point.getY());
            int w = jxl.getWidth();
            int h = jxl.getHeight();
            this.bridgeCC.reset();
            if (point.y <= h && point.x <= w && point.y >= 0 && point.x >= 0) {
                java.awt.geom.Point2D start = ((JImageUrlCanvas)jxl.getView()).convertToComponent(this.pointsIC.get(0).toJavaPoint2D());
                java.awt.geom.Point2D end = ((JImageUrlCanvas)jxl.getView()).convertToComponent(this.pointsIC.get(this.pointsIC.size() - 1).toJavaPoint2D());
                this.bridgeCC.moveTo(start.getX(), start.getY());
                this.bridgeCC.lineTo(this.currentPointCC.getX(), this.currentPointCC.getY());
                this.bridgeCC.lineTo(end.getX(), end.getY());
            }
            this.setDirty(true);
        }
    }

    @Override
    public void resetUI() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.resetRunable.run();
        } else {
            SwingUtilities.invokeLater(this.resetRunable);
        }
    }

    @EventSubscriber(eventClass=IAFRepaintEvent.class)
    public void respondTo(IAFRepaintEvent event) {
        UIDataCoordinator dataCoordinator = (UIDataCoordinator)event.get();
        Collection<Observation> selectedObservations = dataCoordinator.getSelectedObservations();
        Observation selectedObservation = selectedObservations.size() == 1 ? selectedObservations.iterator().next() : null;
        this.setObservation(selectedObservation);
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public void setObservation(Observation observation) {
        Observation oldObservation = this.observation;
        this.observation = observation;
        this.resetUI();
    }

    public JXHorizontalLinePainter<T> getHorizontalLinePainter() {
        return this.horizontalLinePainter;
    }
}

