/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import org.mbari.swing.JImageUrlCanvas;
import vars.annotation.ui.imagepanel.AreaMeasurementLayerUI2;
import vars.annotation.ui.imagepanel.JXAreaMeasurementPainter;
import vars.annotation.ui.imagepanel.JXHorizontalLinePainterDialog;
import vars.annotation.ui.imagepanel.JXNotSelectedAreaMeasurementPainter;
import vars.annotation.ui.imagepanel.MultiLayerUI;
import vars.annotation.ui.imagepanel.UISettingsBuilder;

public class AreaMeasurementLayerSettingsBuilder<T extends JImageUrlCanvas>
implements UISettingsBuilder {
    private JXAreaMeasurementPainter<T> notSelectedAreaMeasurementsPainter = new JXNotSelectedAreaMeasurementPainter<T>();
    private final MultiLayerUI<T> layerUI;
    private final JPanel panel;
    private JCheckBox showNotSelectedCheckBox;
    private JButton showColorChooserButton;
    private JButton showHLineDialogButton;
    private JXHorizontalLinePainterDialog horizontalLinePainterDialog;

    public AreaMeasurementLayerSettingsBuilder(AreaMeasurementLayerUI2<T> layerUI) {
        this.layerUI = layerUI;
        this.horizontalLinePainterDialog = new JXHorizontalLinePainterDialog(layerUI.getHorizontalLinePainter());
        this.horizontalLinePainterDialog.pack();
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.add(this.getShowNotSelectedCheckBox());
        this.panel.add(this.getShowColorChooserButton());
        this.panel.add(this.getShowHLineDialogButton());
    }

    protected JCheckBox getShowNotSelectedCheckBox() {
        if (this.showNotSelectedCheckBox == null) {
            this.showNotSelectedCheckBox = new JCheckBox();
            this.showNotSelectedCheckBox.setText("Show All Area Measurements");
            this.showNotSelectedCheckBox.setSelected(false);
            this.showNotSelectedCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (AreaMeasurementLayerSettingsBuilder.this.showNotSelectedCheckBox.isSelected()) {
                        AreaMeasurementLayerSettingsBuilder.this.layerUI.addPainter(AreaMeasurementLayerSettingsBuilder.this.notSelectedAreaMeasurementsPainter);
                    } else {
                        AreaMeasurementLayerSettingsBuilder.this.layerUI.removePainter(AreaMeasurementLayerSettingsBuilder.this.notSelectedAreaMeasurementsPainter);
                    }
                }
            });
            this.showNotSelectedCheckBox.setSelected(false);
        }
        return this.showNotSelectedCheckBox;
    }

    protected JButton getShowColorChooserButton() {
        if (this.showColorChooserButton == null) {
            this.showColorChooserButton = new JButton("Select Color");
            this.showColorChooserButton.setToolTipText("Select background area measurements color");
            this.showColorChooserButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color color = JColorChooser.showDialog(AreaMeasurementLayerSettingsBuilder.this.panel, "Select background area measurements color", AreaMeasurementLayerSettingsBuilder.this.notSelectedAreaMeasurementsPainter.getPaint());
                    AreaMeasurementLayerSettingsBuilder.this.notSelectedAreaMeasurementsPainter.setPaint(color);
                }
            });
        }
        return this.showColorChooserButton;
    }

    protected JButton getShowHLineDialogButton() {
        if (this.showHLineDialogButton == null) {
            this.showHLineDialogButton = new JButton("Add Lines");
            this.showHLineDialogButton.setToolTipText("Add horizonal lines");
            this.showHLineDialogButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AreaMeasurementLayerSettingsBuilder.this.horizontalLinePainterDialog.setVisible(true);
                }
            });
        }
        return this.showHLineDialogButton;
    }

    @Override
    public void clearPainters() {
        if (this.showNotSelectedCheckBox.isSelected()) {
            this.layerUI.addPainter(this.notSelectedAreaMeasurementsPainter);
        } else {
            this.layerUI.removePainter(this.notSelectedAreaMeasurementsPainter);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }
}

