/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jdesktop.jxlayer.JXLayer;
import org.mbari.swing.JImageUrlCanvas;
import vars.UserAccount;
import vars.annotation.Observation;
import vars.annotation.VideoFrame;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.impl.AddObservationToVideoFrameCmd;
import vars.annotation.ui.eventbus.ObservationsSelectedEvent;
import vars.annotation.ui.imagepanel.AnnotationLayerSettingsBuilder;
import vars.annotation.ui.imagepanel.CommonPainters;
import vars.annotation.ui.imagepanel.IAFRepaintEvent;
import vars.annotation.ui.imagepanel.ImageFrameLayerUI;
import vars.annotation.ui.imagepanel.JXPainter;
import vars.annotation.ui.imagepanel.JXSelectedObservationsPainter;
import vars.annotation.ui.imagepanel.UIDataCoordinator;
import vars.knowledgebase.Concept;

public class AnnotationLayerUI<T extends JImageUrlCanvas>
extends ImageFrameLayerUI<T> {
    private JXPainter<T> selectedObservationsPainter = new JXSelectedObservationsPainter();
    private final Controller controller = new Controller();
    private Point2D clickPoint = new Point2D.Double();
    private Rectangle2D boundingBox;
    private Concept concept;
    private final UIDataCoordinator dataCoordinator;
    private VideoFrame oldVideoFrame;
    private final ToolBelt toolBelt;

    public AnnotationLayerUI(ToolBelt toolBelt, UIDataCoordinator dataCoordinator, CommonPainters<T> commonPainters) {
        super(commonPainters);
        this.setDisplayName("Annotate");
        this.setSettingsBuilder(new AnnotationLayerSettingsBuilder(this));
        this.toolBelt = toolBelt;
        this.dataCoordinator = dataCoordinator;
        AnnotationProcessor.process((Object)((Object)this));
        this.clearPainters();
    }

    @Override
    public void clearPainters() {
        super.clearPainters();
        this.addPainter(this.selectedObservationsPainter);
    }

    public Concept getConcept() {
        if (this.concept == null) {
            this.concept = this.toolBelt.getAnnotationPersistenceService().findRootConcept();
        }
        return this.concept;
    }

    public ToolBelt getToolBelt() {
        return this.toolBelt;
    }

    @Override
    protected void paintLayer(Graphics2D g2, JXLayer<? extends T> jxl) {
        super.paintLayer(g2, jxl);
        g2.setPaintMode();
        if (this.dataCoordinator.getVideoFrame() != null && this.boundingBox != null) {
            g2.setPaint(Color.MAGENTA);
            g2.setXORMode(Color.WHITE);
            g2.setStroke(new BasicStroke(3.0f, 1, 1, 0.0f, new float[]{2.0f, 2.0f}, 2.0f));
            g2.draw(this.boundingBox);
            g2.setPaintMode();
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent me, JXLayer<? extends T> jxl) {
        super.processMouseEvent(me, jxl);
        Point point = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), jxl);
        switch (me.getID()) {
            case 501: {
                this.clickPoint.setLocation((int)Math.round(point.getX()), (int)Math.round(point.getY()));
                break;
            }
            case 502: {
                if (me.getButton() != 1) {
                    this.controller.sendSelectionNotification(new HashSet<Observation>());
                    this.setDirty(true);
                    break;
                }
                if (this.boundingBox == null) {
                    Point2D imagePoint = ((JImageUrlCanvas)jxl.getView()).convertToImage((Point2D)point);
                    this.controller.newObservation(imagePoint);
                    break;
                }
                Rectangle r = this.boundingBox.getBounds();
                this.boundingBox = null;
                VideoFrame videoFrame = this.dataCoordinator.getVideoFrame();
                if (videoFrame == null) break;
                HashSet<Observation> selectedObservations = new HashSet<Observation>();
                for (Observation observation : videoFrame.getObservations()) {
                    Point2D imagePoint;
                    if (observation.getX() == null || observation.getY() == null || (imagePoint = ((JImageUrlCanvas)jxl.getView()).convertToComponent((Point2D)new Point2D.Double(observation.getX(), observation.getY()))) == null || !r.contains(imagePoint)) continue;
                    selectedObservations.add(observation);
                }
                this.controller.sendSelectionNotification(selectedObservations);
                break;
            }
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent me, JXLayer<? extends T> jxl) {
        super.processMouseMotionEvent(me, jxl);
        switch (me.getID()) {
            case 506: {
                Point point = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), jxl);
                int x1 = (int)Math.round(point.getX());
                int y1 = (int)Math.round(point.getY());
                int x0 = (int)this.clickPoint.getX();
                int y0 = (int)this.clickPoint.getY();
                int w = Math.abs(x1 - x0);
                int h = Math.abs(y1 - y0);
                int x = Math.min(x0, x1);
                int y = Math.min(y0, y1);
                if (this.boundingBox == null) {
                    this.boundingBox = new Rectangle2D.Double(x, y, w, h);
                } else {
                    this.boundingBox.setRect(x, y, w, h);
                }
                this.setDirty(true);
                break;
            }
        }
    }

    @EventSubscriber(eventClass=IAFRepaintEvent.class)
    public void respondTo(IAFRepaintEvent event) {
        VideoFrame videoFrame = ((UIDataCoordinator)event.get()).getVideoFrame();
        if (videoFrame == null || !videoFrame.equals(this.oldVideoFrame)) {
            this.oldVideoFrame = videoFrame;
            this.boundingBox = null;
        }
        this.setDirty(true);
    }

    public void setConcept(Concept concept) {
        this.concept = concept;
    }

    private class Controller {
        private Controller() {
        }

        void newObservation(Point2D point) {
            String conceptName = AnnotationLayerUI.this.getConcept().getPrimaryConceptName().getName();
            UserAccount userAccount = StateLookup.getUserAccount();
            String user = userAccount.getUserName();
            VideoFrame videoFrame = AnnotationLayerUI.this.dataCoordinator.getVideoFrame();
            if (videoFrame != null) {
                AddObservationToVideoFrameCmd command = new AddObservationToVideoFrameCmd(conceptName, AnnotationLayerUI.this.dataCoordinator.getVideoFrame(), user, point, true);
                CommandEvent commandEvent = new CommandEvent(command);
                EventBus.publish((Object)commandEvent);
            }
        }

        void sendSelectionNotification(Collection<Observation> selectedObservations) {
            EventBus.publish((Object)new ObservationsSelectedEvent((Object)AnnotationLayerUI.this, selectedObservations));
        }
    }
}

