/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.dialogs;

import java.awt.Component;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.ui.dialogs.IVideoSourcePanel;
import vars.annotation.ui.dialogs.VideoSourcePanelTape;
import vars.annotation.ui.dialogs.VideoSourceSelectionPanelController;

public class VideoSourceSelectionPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(VideoSourceSelectionPanel.class);
    private final VideoSourceSelectionPanelController controller = new VideoSourceSelectionPanelController(this);
    private final String videoSource = "Video-Tape";
    private JPanel selectedPanel;
    private VideoSourcePanelTape videoSourcePanel;

    public VideoSourceSelectionPanel(AnnotationDAOFactory annotationDAOFactory) {
        this.videoSourcePanel = new VideoSourcePanelTape(annotationDAOFactory);
        this.initialize();
        String defaultVideoSource = this.controller.getProperty("video.source.default");
        this.setVideoSource(defaultVideoSource);
    }

    private void initialize() {
    }

    public void open() {
        IVideoSourcePanel p = (IVideoSourcePanel)((Object)this.selectedPanel);
        if (p.isValidVideoSource()) {
            p.open();
        } else {
            log.info("Tried calling open on an invalid IVideoSourcePanel. The request was ignored");
        }
    }

    public void setVideoSource(String source) {
        if (source == null || source.equalsIgnoreCase("tape")) {
            this.videoSourcePanel.getHdCheckBox().setSelected(false);
        } else {
            this.videoSourcePanel.getHdCheckBox().setSelected(true);
        }
        this.videoSourcePanel.removeAll();
        this.videoSourcePanel.add((Component)this.selectedPanel, "Center");
        this.revalidate();
        this.repaint();
    }
}

