/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.mbari.awt.event.NonDigitConsumingKeyListener;
import org.mbari.text.IgnoreCaseToStringComparator;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.ui.VARSProperties;
import vars.annotation.ui.actions.OpenVideoArchiveUsingParamsAction;
import vars.annotation.ui.dialogs.IVideoSourcePanel;

public class VideoSourcePanelTape
extends JPanel
implements IVideoSourcePanel {
    public static final String PROP_VALID_VIDEO_SOURCE = "validVideoSource";
    private OpenVideoArchiveUsingParamsAction openAction;
    private JComboBox cameraPlatformComboBox;
    private JTextField diveNumberTextField;
    private JCheckBox hdCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField tapeNumberTextField;

    public VideoSourcePanelTape(AnnotationDAOFactory annotationDAOFactory) {
        this.openAction = new OpenVideoArchiveUsingParamsAction(annotationDAOFactory);
        this.initComponents();
        this.postInit();
    }

    private void postInit() {
        this.diveNumberTextField.addKeyListener((KeyListener)((Object)new LocalKeyAdapter()));
        this.tapeNumberTextField.addKeyListener((KeyListener)((Object)new LocalKeyAdapter()));
        this.hdCheckBox.setSelected(false);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cameraPlatformComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.diveNumberTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.tapeNumberTextField = new JTextField();
        this.hdCheckBox = new JCheckBox();
        this.jLabel1.setText("Camera Platform:");
        this.cameraPlatformComboBox.setModel(new DefaultComboBoxModel<String>(this.listCameraPlatforms()));
        this.jLabel2.setText("Dive Number:");
        this.jLabel3.setText("Tape Number:");
        this.hdCheckBox.setText("Check if High Definition");
        this.hdCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.hdCheckBox.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout((Container)this);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.cameraPlatformComboBox, 0, 342, Short.MAX_VALUE).add((Component)this.diveNumberTextField, -1, 342, Short.MAX_VALUE).add((Component)this.tapeNumberTextField, -1, 342, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add(157, 157, 157).add((Component)this.hdCheckBox))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.cameraPlatformComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.diveNumberTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.tapeNumberTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.hdCheckBox).addContainerGap(19, Short.MAX_VALUE)));
        this.setLayout((LayoutManager)layout);
    }

    @Override
    public void open() {
        this.validateVideoSource();
        if (this.isValidVideoSource()) {
            int seqNumber = Integer.parseInt(this.diveNumberTextField.getText());
            String platform = (String)this.cameraPlatformComboBox.getSelectedItem();
            int tapeNumber = Integer.parseInt(this.tapeNumberTextField.getText());
            this.openAction.setPlatform(platform);
            this.openAction.setSeqNumber(seqNumber);
            this.openAction.setTapeNumber(tapeNumber);
            String postfix = this.hdCheckBox.isSelected() ? "HD" : null;
            this.openAction.setPostfix(postfix);
            this.openAction.doAction();
        }
    }

    private String[] listCameraPlatforms() {
        Collection<String> cameraPlatforms = VARSProperties.getCameraPlatforms();
        String[] cp = new String[cameraPlatforms.size()];
        cameraPlatforms.toArray(cp);
        Arrays.sort(cp, new IgnoreCaseToStringComparator());
        return cp;
    }

    @Override
    public boolean isValidVideoSource() {
        return true;
    }

    private void validateVideoSource() {
    }

    public JCheckBox getHdCheckBox() {
        return this.hdCheckBox;
    }

    class LocalKeyAdapter
    extends NonDigitConsumingKeyListener {
        LocalKeyAdapter() {
        }

        public void keyTyped(KeyEvent e) {
            super.keyTyped(e);
            VideoSourcePanelTape.this.validateVideoSource();
        }
    }
}

