/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.dialogs;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.bushe.swing.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.AnnotationPersistenceService;
import vars.annotation.ui.StateLookup;
import vars.knowledgebase.Concept;
import vars.shared.ui.HierachicalConceptNameComboBox;
import vars.shared.ui.dialogs.StandardDialog;

public class ToConceptSelectionDialog
extends StandardDialog {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AnnotationPersistenceService annotationPersistenceService;
    private HierachicalConceptNameComboBox comboBox;

    @Inject
    public ToConceptSelectionDialog(AnnotationPersistenceService annotationPersistenceService) {
        this(annotationPersistenceService, "physical-object");
    }

    public ToConceptSelectionDialog(AnnotationPersistenceService annotationPersistenceService, String conceptName) {
        super((Frame)StateLookup.getAnnotationFrame());
        this.annotationPersistenceService = annotationPersistenceService;
        try {
            this.initialize();
            this.setBaseConceptName(conceptName);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void setBaseConceptName(String conceptName) {
        try {
            Concept concept = this.annotationPersistenceService.findConceptByName(conceptName);
            if (concept == null) {
                concept = this.annotationPersistenceService.findRootConcept();
            }
            this.getComboBox().setConcept(concept);
            this.getComboBox().setSelectedItem((Object)concept.getPrimaryConceptName().getName());
        }
        catch (Exception ex) {
            this.log.error("Failed to lookup concepts from knowledgebase", (Throwable)ex);
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)ex);
        }
    }

    protected HierachicalConceptNameComboBox getComboBox() {
        if (this.comboBox == null) {
            this.comboBox = new HierachicalConceptNameComboBox(this.annotationPersistenceService);
            Dimension size = this.comboBox.getPreferredSize();
            Dimension preferredSize = new Dimension(350, size.height);
            this.comboBox.setPreferredSize(preferredSize);
            this.comboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent ke) {
                    char c = ke.getKeyChar();
                    if (c == '\n') {
                        ToConceptSelectionDialog.this.getOkayButton().doClick();
                    }
                }
            });
        }
        return this.comboBox;
    }

    public Concept getSelectedConcept() {
        String conceptName = (String)this.getComboBox().getSelectedItem();
        Concept concept = null;
        try {
            concept = this.annotationPersistenceService.findConceptByName(conceptName);
        }
        catch (Exception e) {
            this.log.error("Failed to lookup '" + conceptName + "' from the knowledgebase", (Throwable)e);
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
        }
        return concept;
    }

    private void initialize() throws Exception {
        this.setModal(true);
        this.setTitle("VARS - Select Concept");
        this.getContentPane().add((Component)this.getComboBox(), "Center");
        this.getCancelButton().addActionListener(e -> this.dispose());
        this.getOkayButton().addActionListener(e -> this.dispose());
        this.getRootPane().setDefaultButton(this.getOkayButton());
        this.addHierarchyListener(e -> {
            if (4L == (4L & e.getChangeFlags())) {
                this.getRootPane().setDefaultButton(this.getOkayButton());
            }
        });
        this.pack();
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.getComboBox().requestFocusInWindow();
        }
    }
}

