/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.eventbus.VideoArchiveChangedEvent;
import vars.annotation.ui.eventbus.VideoArchiveSelectedEvent;
import vars.shared.ui.dialogs.StandardDialog;

public class RenameVideoArchivePathDialog
extends StandardDialog {
    private final ToolBelt toolBelt;
    private JScrollPane scrollPane;
    private JTextField textField;
    private JLabel errorLabel;
    private JPanel centerPanel;
    private VideoArchive videoArchive;

    public RenameVideoArchivePathDialog(Window parent, ToolBelt toolBelt) {
        super(parent);
        this.toolBelt = toolBelt;
        this.initialize();
        this.getRootPane().setDefaultButton(this.getOkayButton());
        this.pack();
        VideoArchive va = StateLookup.getVideoArchive();
        this.setVideoArchive(va);
        AnnotationProcessor.process((Object)((Object)this));
    }

    public String getNewVideoArchiveName() {
        return this.getTextField().getText();
    }

    private void initialize() {
        this.getOkayButton().setEnabled(false);
        this.getOkayButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = RenameVideoArchivePathDialog.this.getTextField().getText();
                VideoArchiveDAO dao = RenameVideoArchivePathDialog.this.toolBelt.getAnnotationDAOFactory().newVideoArchiveDAO();
                dao.startTransaction();
                VideoArchive existingVideoArchive = dao.findByName(name);
                dao.endTransaction();
                if (existingVideoArchive != null) {
                    if (existingVideoArchive.equals(RenameVideoArchivePathDialog.this.videoArchive)) {
                        RenameVideoArchivePathDialog.this.getErrorLabel().setText("You haven't changed the name.");
                    } else {
                        RenameVideoArchivePathDialog.this.getErrorLabel().setText("That name is already used in the database. Pick a different name.");
                    }
                } else {
                    RenameVideoArchivePathDialog.this.getErrorLabel().setText(null);
                    RenameVideoArchivePathDialog.this.setVisible(false);
                }
            }
        });
        this.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenameVideoArchivePathDialog.this.getErrorLabel().setText(null);
                RenameVideoArchivePathDialog.this.getTextField().setText(RenameVideoArchivePathDialog.this.videoArchive.getName());
                RenameVideoArchivePathDialog.this.setVisible(false);
            }
        });
        this.getContentPane().add((Component)this.getCenterPanel(), "Center");
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.getTextField());
            this.scrollPane.setVerticalScrollBarPolicy(21);
            this.scrollPane.setHorizontalScrollBarPolicy(32);
        }
        return this.scrollPane;
    }

    private JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField(50);
        }
        return this.textField;
    }

    private JLabel getErrorLabel() {
        if (this.errorLabel == null) {
            this.errorLabel = new JLabel();
            this.errorLabel.setForeground(Color.RED);
        }
        return this.errorLabel;
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
            this.centerPanel.add(this.getScrollPane());
            this.centerPanel.add(this.getErrorLabel());
        }
        return this.centerPanel;
    }

    @EventSubscriber(eventClass=VideoArchiveChangedEvent.class)
    public void respondTo(VideoArchiveChangedEvent event) {
        this.setVideoArchive((VideoArchive)event.get());
    }

    @EventSubscriber(eventClass=VideoArchiveSelectedEvent.class)
    public void respondTo(VideoArchiveSelectedEvent event) {
        this.setVideoArchive((VideoArchive)event.get());
    }

    private void setVideoArchive(VideoArchive videoArchive) {
        this.videoArchive = videoArchive;
        this.getErrorLabel().setText(null);
        if (videoArchive == null) {
            this.getTextField().setText(null);
            this.getOkayButton().setEnabled(false);
        } else {
            this.getTextField().setText(videoArchive.getName());
            this.getOkayButton().setEnabled(true);
        }
    }
}

