/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.mbari.awt.event.NonDigitConsumingKeyListener;
import org.mbari.swing.SpinningDialWaitIndicator;
import org.mbari.text.IgnoreCaseToStringComparator;
import vars.CacheClearedEvent;
import vars.CacheClearedListener;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.ui.PersistenceController;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.VARSProperties;
import vars.shared.ui.dialogs.StandardDialog;

public class RenameVideoArchiveDialog
extends StandardDialog {
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final ItemListener rbItemListener = new SelectedRBItemListener();
    private boolean loadExistingNames = true;
    private JComboBox cameraPlatformComboBox;
    private JComboBox existingNamesComboBox;
    private JCheckBox hdCheckBox;
    private JLabel lblCameraPlatform;
    private JLabel lblName;
    private JLabel lblSelectName;
    private JLabel lblSequenceNumber;
    private JLabel lblTapeNumber;
    private JTextField nameTextField;
    private JRadioButton openByNameRB;
    private JRadioButton openByPlatformRB;
    private JRadioButton openExistingRB;
    private JPanel panel;
    private JTextField sequenceNumberTextField;
    private JTextField tapeNumberTextField;
    private final ToolBelt toolBelt;

    public RenameVideoArchiveDialog(Window parent, ToolBelt toolBelt) {
        super(parent);
        this.toolBelt = toolBelt;
        this.initialize();
        this.getRootPane().setDefaultButton(this.getOkayButton());
        this.pack();
        toolBelt.getPersistenceCache().addCacheClearedListener(new CacheClearedListener(){

            public void afterClear(CacheClearedEvent evt) {
                RenameVideoArchiveDialog.this.loadExistingNames = true;
            }

            public void beforeClear(CacheClearedEvent evt) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)RenameVideoArchiveDialog.this.getExistingNamesComboBox().getModel();
                model.removeAllElements();
            }
        });
    }

    private JComboBox getCameraPlatformComboBox() {
        if (this.cameraPlatformComboBox == null) {
            this.cameraPlatformComboBox = new JComboBox();
            this.cameraPlatformComboBox.setModel(new DefaultComboBoxModel<String>(this.listCameraPlatforms()));
        }
        return this.cameraPlatformComboBox;
    }

    private JComboBox getExistingNamesComboBox() {
        if (this.existingNamesComboBox == null) {
            this.existingNamesComboBox = new JComboBox();
            this.existingNamesComboBox.setEnabled(false);
        }
        return this.existingNamesComboBox;
    }

    private JCheckBox getHdCheckBox() {
        if (this.hdCheckBox == null) {
            this.hdCheckBox = new JCheckBox("Check if High Definition");
            this.hdCheckBox.setSelected(true);
            this.hdCheckBox.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        RenameVideoArchiveDialog.this.getOkayButton().doClick();
                    }
                    super.keyReleased(e);
                }
            });
        }
        return this.hdCheckBox;
    }

    private JLabel getLblCameraPlatform() {
        if (this.lblCameraPlatform == null) {
            this.lblCameraPlatform = new JLabel("Camera Platform:");
        }
        return this.lblCameraPlatform;
    }

    private JLabel getLblName() {
        if (this.lblName == null) {
            this.lblName = new JLabel("Name:");
        }
        return this.lblName;
    }

    private JLabel getLblSelectName() {
        if (this.lblSelectName == null) {
            this.lblSelectName = new JLabel("Select Name:");
        }
        return this.lblSelectName;
    }

    private JLabel getLblSequenceNumber() {
        if (this.lblSequenceNumber == null) {
            this.lblSequenceNumber = new JLabel("Sequence Number:");
        }
        return this.lblSequenceNumber;
    }

    private JLabel getLblTapeNumber() {
        if (this.lblTapeNumber == null) {
            this.lblTapeNumber = new JLabel("Tape Number:");
        }
        return this.lblTapeNumber;
    }

    private JTextField getNameTextField() {
        if (this.nameTextField == null) {
            this.nameTextField = new JTextField();
            this.nameTextField.setColumns(10);
        }
        return this.nameTextField;
    }

    public String getNewVideoArchiveName() {
        Enumeration<AbstractButton> e = this.buttonGroup.getElements();
        OpenType openType = null;
        while (e.hasMoreElements()) {
            AbstractButton b = e.nextElement();
            if (!b.isSelected()) continue;
            openType = OpenType.valueOf(b.getName());
            break;
        }
        VideoArchiveDAO dao = this.toolBelt.getAnnotationDAOFactory().newVideoArchiveDAO();
        dao.startTransaction();
        String newName = null;
        switch (openType) {
            case BY_NAME: {
                newName = this.getNameTextField().getText();
                break;
            }
            case BY_PARAMS: {
                int sequenceNumber = Integer.parseInt(this.getSequenceNumberTextField().getText());
                String platform = (String)this.getCameraPlatformComboBox().getSelectedItem();
                int tapeNumber = Integer.parseInt(this.getTapeNumberTextField().getText());
                String postfix = this.getHdCheckBox().isSelected() ? "HD" : null;
                newName = PersistenceController.makeVideoArchiveName(platform, sequenceNumber, tapeNumber, postfix);
                break;
            }
            case EXISTING: {
                newName = (String)this.getExistingNamesComboBox().getSelectedItem();
                break;
            }
        }
        return newName;
    }

    private JRadioButton getOpenByNameRB() {
        if (this.openByNameRB == null) {
            this.openByNameRB = new JRadioButton("Rename");
            this.openByNameRB.setName(OpenType.BY_NAME.name());
            this.openByNameRB.addItemListener(this.rbItemListener);
        }
        return this.openByNameRB;
    }

    private JRadioButton getOpenByPlatformRB() {
        if (this.openByPlatformRB == null) {
            this.openByPlatformRB = new JRadioButton("Rename by Platform and Sequence Number");
            this.openByPlatformRB.setName(OpenType.BY_PARAMS.name());
            this.openByPlatformRB.addItemListener(this.rbItemListener);
        }
        return this.openByPlatformRB;
    }

    private JRadioButton getOpenExistingRB() {
        if (this.openExistingRB == null) {
            this.openExistingRB = new JRadioButton("Open Existing");
            this.openExistingRB.setEnabled(false);
            this.openExistingRB.setName(OpenType.EXISTING.name());
            this.openExistingRB.addItemListener(this.rbItemListener);
            this.openExistingRB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (RenameVideoArchiveDialog.this.loadExistingNames) {
                        JComboBox comboBox = RenameVideoArchiveDialog.this.getExistingNamesComboBox();
                        SpinningDialWaitIndicator waitIndicator = new SpinningDialWaitIndicator((JComponent)comboBox);
                        List names = RenameVideoArchiveDialog.this.toolBelt.getAnnotationPersistenceService().findAllVideoArchiveNames();
                        String[] van = new String[names.size()];
                        names.toArray(van);
                        comboBox.setModel(new DefaultComboBoxModel<String>(van));
                        waitIndicator.dispose();
                        RenameVideoArchiveDialog.this.loadExistingNames = false;
                    }
                }
            });
        }
        return this.openExistingRB;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            GroupLayout gl_panel = new GroupLayout(this.panel);
            gl_panel.setHorizontalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addContainerGap().addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getOpenByPlatformRB()).addGroup(gl_panel.createSequentialGroup().addGap(29).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getLblSequenceNumber()).addComponent(this.getLblCameraPlatform()).addComponent(this.getLblTapeNumber())).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getHdCheckBox()).addComponent(this.getCameraPlatformComboBox(), 0, 325, Short.MAX_VALUE).addComponent(this.getSequenceNumberTextField(), -1, 325, Short.MAX_VALUE).addComponent(this.getTapeNumberTextField(), -1, 286, Short.MAX_VALUE))).addGroup(gl_panel.createSequentialGroup().addGap(29).addComponent(this.getLblName()).addGap(83).addComponent(this.getNameTextField(), -1, 325, Short.MAX_VALUE)).addGroup(gl_panel.createSequentialGroup().addComponent(this.getOpenByNameRB()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 314, Short.MAX_VALUE)).addGroup(gl_panel.createSequentialGroup().addGap(29).addComponent(this.getLblSelectName()).addGap(42).addComponent(this.getExistingNamesComboBox(), 0, 325, Short.MAX_VALUE)).addComponent(this.getOpenExistingRB())).addContainerGap()));
            gl_panel.setVerticalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addContainerGap().addComponent(this.getOpenByPlatformRB()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblCameraPlatform()).addComponent(this.getCameraPlatformComboBox(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblSequenceNumber()).addComponent(this.getSequenceNumberTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getLblTapeNumber()).addComponent(this.getTapeNumberTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getHdCheckBox()).addGap(4).addComponent(this.getOpenByNameRB()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblName()).addComponent(this.getNameTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getOpenExistingRB()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblSelectName()).addComponent(this.getExistingNamesComboBox(), -2, -1, -2))));
            this.panel.setLayout(gl_panel);
            this.buttonGroup.add(this.getOpenByNameRB());
            this.buttonGroup.add(this.getOpenByPlatformRB());
            this.buttonGroup.add(this.getOpenExistingRB());
            this.buttonGroup.setSelected(this.getOpenByPlatformRB().getModel(), true);
        }
        return this.panel;
    }

    private JTextField getSequenceNumberTextField() {
        if (this.sequenceNumberTextField == null) {
            this.sequenceNumberTextField = new JTextField();
            this.sequenceNumberTextField.setColumns(10);
            this.sequenceNumberTextField.addKeyListener((KeyListener)new NonDigitConsumingKeyListener());
        }
        return this.sequenceNumberTextField;
    }

    private JTextField getTapeNumberTextField() {
        if (this.tapeNumberTextField == null) {
            this.tapeNumberTextField = new JTextField();
            this.tapeNumberTextField.setColumns(10);
            this.tapeNumberTextField.addKeyListener((KeyListener)new NonDigitConsumingKeyListener());
            this.tapeNumberTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        RenameVideoArchiveDialog.this.getOkayButton().doClick();
                    }
                    super.keyReleased(e);
                }
            });
        }
        return this.tapeNumberTextField;
    }

    protected void initialize() {
        this.setPreferredSize(new Dimension(475, 400));
        this.getOkayButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenameVideoArchiveDialog.this.setVisible(false);
            }
        });
        this.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenameVideoArchiveDialog.this.setVisible(false);
            }
        });
        this.getContentPane().add((Component)this.getPanel(), "Center");
    }

    private String[] listCameraPlatforms() {
        Collection<String> cameraPlatforms = VARSProperties.getCameraPlatforms();
        String[] cp = new String[cameraPlatforms.size()];
        cameraPlatforms.toArray(cp);
        Arrays.sort(cp, new IgnoreCaseToStringComparator());
        return cp;
    }

    class SelectedRBItemListener
    implements ItemListener {
        SelectedRBItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                JRadioButton radioButton = (JRadioButton)e.getItemSelectable();
                OpenType openType = OpenType.valueOf(radioButton.getName());
                boolean cameraPlatformCB = false;
                boolean sequenceNumberTF = false;
                boolean hdChckB = false;
                boolean nameTF = false;
                boolean existingNamesCB = false;
                boolean tapeNumberTF = false;
                switch (openType) {
                    case BY_NAME: {
                        nameTF = true;
                        break;
                    }
                    case BY_PARAMS: {
                        cameraPlatformCB = true;
                        sequenceNumberTF = true;
                        tapeNumberTF = true;
                        hdChckB = true;
                        break;
                    }
                    case EXISTING: {
                        existingNamesCB = true;
                        break;
                    }
                }
                RenameVideoArchiveDialog.this.getCameraPlatformComboBox().setEnabled(cameraPlatformCB);
                RenameVideoArchiveDialog.this.getSequenceNumberTextField().setEnabled(sequenceNumberTF);
                RenameVideoArchiveDialog.this.getHdCheckBox().setEnabled(hdChckB);
                RenameVideoArchiveDialog.this.getNameTextField().setEnabled(nameTF);
                RenameVideoArchiveDialog.this.getExistingNamesComboBox().setEnabled(existingNamesCB);
                RenameVideoArchiveDialog.this.getTapeNumberTextField().setEnabled(tapeNumberTF);
            }
        }
    }

    private static enum OpenType {
        BY_PARAMS,
        BY_NAME,
        EXISTING;

    }
}

