/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.mbari.awt.event.NonDigitConsumingKeyListener;
import org.mbari.swing.SpinningDialWaitIndicator;
import vars.CacheClearedEvent;
import vars.CacheClearedListener;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.ui.PersistenceController;
import vars.annotation.ui.ToolBelt;
import vars.shared.ui.dialogs.StandardDialog;

public class OpenVideoArchiveDialog
extends StandardDialog {
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final ItemListener rbItemListener = new SelectedRBItemListener();
    private JComboBox<String> cameraPlatformComboBox;
    private JComboBox<String> existingNamesComboBox;
    private boolean loadExistingNames = true;
    private JCheckBox hdCheckBox;
    private JLabel lblCameraPlatform;
    private JLabel lblName;
    private JLabel lblSelectName;
    private JLabel lblSequenceNumber;
    private JLabel lblTapeNumber;
    private JTextField nameTextField;
    private JRadioButton openByNameRB;
    private JRadioButton openByPlatformRB;
    private JRadioButton openExistingRB;
    private JPanel panel;
    private JTextField sequenceNumberTextField;
    private JTextField tapeNumberTextField;
    private JComboBox<String> cameraPlatformByNameComboBox;
    private final ToolBelt toolBelt;
    private JTextField sequenceNumberByNameTextField;

    public OpenVideoArchiveDialog(Window parent, ToolBelt toolBelt) {
        super(parent);
        this.toolBelt = toolBelt;
        this.initialize();
        this.getRootPane().setDefaultButton(this.getOkayButton());
        this.pack();
        toolBelt.getPersistenceCache().addCacheClearedListener(new CacheClearedListener(){

            public void afterClear(CacheClearedEvent evt) {
                OpenVideoArchiveDialog.this.loadExistingNames = true;
            }

            public void beforeClear(CacheClearedEvent evt) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)OpenVideoArchiveDialog.this.getExistingNamesComboBox().getModel();
                model.removeAllElements();
            }
        });
    }

    private JComboBox<String> getCameraPlatformComboBox() {
        if (this.cameraPlatformComboBox == null) {
            this.cameraPlatformComboBox = new JComboBox();
            this.cameraPlatformComboBox.setModel(new DefaultComboBoxModel<String>(this.listCameraPlatforms()));
        }
        return this.cameraPlatformComboBox;
    }

    private JComboBox<String> getCameraPlatformByNameComboBox() {
        if (this.cameraPlatformByNameComboBox == null) {
            this.cameraPlatformByNameComboBox = new JComboBox();
            this.cameraPlatformByNameComboBox.setModel(new DefaultComboBoxModel<String>(this.listCameraPlatforms()));
        }
        return this.cameraPlatformByNameComboBox;
    }

    private JComboBox<String> getExistingNamesComboBox() {
        if (this.existingNamesComboBox == null) {
            this.existingNamesComboBox = new JComboBox();
        }
        return this.existingNamesComboBox;
    }

    private JCheckBox getHdCheckBox() {
        if (this.hdCheckBox == null) {
            this.hdCheckBox = new JCheckBox("Check if High Definition");
            this.hdCheckBox.setSelected(true);
            this.hdCheckBox.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        OpenVideoArchiveDialog.this.getOkayButton().doClick();
                    }
                    super.keyReleased(e);
                }
            });
        }
        return this.hdCheckBox;
    }

    private JLabel getLblCameraPlatform() {
        if (this.lblCameraPlatform == null) {
            this.lblCameraPlatform = new JLabel("Camera Platform:");
        }
        return this.lblCameraPlatform;
    }

    private JLabel getLblName() {
        if (this.lblName == null) {
            this.lblName = new JLabel("Name:");
        }
        return this.lblName;
    }

    private JLabel getLblSelectName() {
        if (this.lblSelectName == null) {
            this.lblSelectName = new JLabel("Select Name:");
        }
        return this.lblSelectName;
    }

    private JLabel getLblSequenceNumber() {
        if (this.lblSequenceNumber == null) {
            this.lblSequenceNumber = new JLabel("Sequence Number:");
        }
        return this.lblSequenceNumber;
    }

    private JLabel getLblTapeNumber() {
        if (this.lblTapeNumber == null) {
            this.lblTapeNumber = new JLabel("Tape Number:");
        }
        return this.lblTapeNumber;
    }

    private JTextField getNameTextField() {
        if (this.nameTextField == null) {
            this.nameTextField = new JTextField();
            this.nameTextField.setColumns(10);
        }
        return this.nameTextField;
    }

    private JRadioButton getOpenByNameRB() {
        if (this.openByNameRB == null) {
            this.openByNameRB = new JRadioButton("Open by Name");
            this.openByNameRB.setName(OpenType.BY_NAME.name());
            this.openByNameRB.addItemListener(this.rbItemListener);
        }
        return this.openByNameRB;
    }

    private JRadioButton getOpenByPlatformRB() {
        if (this.openByPlatformRB == null) {
            this.openByPlatformRB = new JRadioButton("Open by Platform and Sequence Number");
            this.openByPlatformRB.setName(OpenType.BY_PARAMS.name());
            this.openByPlatformRB.addItemListener(this.rbItemListener);
        }
        return this.openByPlatformRB;
    }

    private JRadioButton getOpenExistingRB() {
        if (this.openExistingRB == null) {
            this.openExistingRB = new JRadioButton("Open Existing");
            this.openExistingRB.setName(OpenType.EXISTING.name());
            this.openExistingRB.addItemListener(this.rbItemListener);
            this.openExistingRB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (OpenVideoArchiveDialog.this.loadExistingNames) {
                        JComboBox comboBox = OpenVideoArchiveDialog.this.getExistingNamesComboBox();
                        SpinningDialWaitIndicator waitIndicator = new SpinningDialWaitIndicator((JComponent)comboBox);
                        List names = OpenVideoArchiveDialog.this.toolBelt.getAnnotationPersistenceService().findAllVideoArchiveNames();
                        String[] van = new String[names.size()];
                        names.toArray(van);
                        comboBox.setModel(new DefaultComboBoxModel<String>(van));
                        waitIndicator.dispose();
                        OpenVideoArchiveDialog.this.loadExistingNames = false;
                    }
                }
            });
        }
        return this.openExistingRB;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            JLabel cameraByNameLabel = new JLabel("Camera Platform:");
            JLabel sequenceNumberByNameLabel = new JLabel("Sequence Number:");
            GroupLayout groupLayout = new GroupLayout(this.panel);
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getOpenByPlatformRB()).addComponent(this.getOpenByNameRB()).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getOpenExistingRB()).addGroup(groupLayout.createSequentialGroup().addGap(29).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(cameraByNameLabel).addComponent(this.getLblName()).addComponent(sequenceNumberByNameLabel))).addGroup(groupLayout.createSequentialGroup().addGap(29).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getLblCameraPlatform()).addComponent(this.getLblSequenceNumber()).addComponent(this.getLblTapeNumber()))).addGroup(groupLayout.createSequentialGroup().addGap(29).addComponent(this.getLblSelectName()))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getCameraPlatformByNameComboBox(), 0, 185, Short.MAX_VALUE).addComponent(this.getNameTextField(), GroupLayout.Alignment.TRAILING, -1, 299, Short.MAX_VALUE).addComponent(this.getSequenceNumberByNameTextField(), -1, 299, Short.MAX_VALUE).addComponent(this.getExistingNamesComboBox(), 0, 185, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getSequenceNumberTextField(), -1, 185, Short.MAX_VALUE).addComponent(this.getTapeNumberTextField(), -1, 185, Short.MAX_VALUE).addComponent(this.getCameraPlatformComboBox(), 0, 185, Short.MAX_VALUE).addComponent(this.getHdCheckBox())))))).addContainerGap()));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.getOpenByPlatformRB()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblCameraPlatform()).addComponent(this.getCameraPlatformComboBox(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblSequenceNumber()).addComponent(this.getSequenceNumberTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblTapeNumber()).addComponent(this.getTapeNumberTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getHdCheckBox()).addGap(4).addComponent(this.getOpenByNameRB()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getNameTextField(), -2, -1, -2).addComponent(this.getLblName())).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getCameraPlatformByNameComboBox(), -2, -1, -2).addComponent(cameraByNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(sequenceNumberByNameLabel).addComponent(this.getSequenceNumberByNameTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getOpenExistingRB()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblSelectName()).addComponent(this.getExistingNamesComboBox(), -2, -1, -2)).addContainerGap(60, Short.MAX_VALUE)));
            this.panel.setLayout(groupLayout);
            this.buttonGroup.add(this.getOpenByNameRB());
            this.buttonGroup.add(this.getOpenByPlatformRB());
            this.buttonGroup.add(this.getOpenExistingRB());
            this.buttonGroup.setSelected(this.getOpenByPlatformRB().getModel(), true);
        }
        return this.panel;
    }

    private JTextField getSequenceNumberTextField() {
        if (this.sequenceNumberTextField == null) {
            this.sequenceNumberTextField = new JTextField();
            this.sequenceNumberTextField.setColumns(10);
            this.sequenceNumberTextField.addKeyListener((KeyListener)new NonDigitConsumingKeyListener());
        }
        return this.sequenceNumberTextField;
    }

    private JTextField getTapeNumberTextField() {
        if (this.tapeNumberTextField == null) {
            this.tapeNumberTextField = new JTextField();
            this.tapeNumberTextField.setColumns(10);
            this.tapeNumberTextField.addKeyListener((KeyListener)new NonDigitConsumingKeyListener());
            this.tapeNumberTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        OpenVideoArchiveDialog.this.getOkayButton().doClick();
                    }
                    super.keyReleased(e);
                }
            });
        }
        return this.tapeNumberTextField;
    }

    protected void initialize() {
        this.setPreferredSize(new Dimension(475, 475));
        this.getOkayButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenVideoArchiveDialog.this.setVisible(false);
            }
        });
        this.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenVideoArchiveDialog.this.setVisible(false);
            }
        });
        this.getContentPane().add((Component)this.getPanel(), "Center");
    }

    private String[] listCameraPlatforms() {
        String[] cp = new String[]{};
        try {
            List cameraPlatforms = this.toolBelt.getAnnotationPersistenceService().findAllCameraPlatforms();
            cp = new String[cameraPlatforms.size()];
            cameraPlatforms.toArray(cp);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return cp;
    }

    public VideoArchive openVideoArchive() {
        VideoArchive videoArchive = null;
        Enumeration<AbstractButton> e = this.buttonGroup.getElements();
        Enum openType = null;
        while (e.hasMoreElements()) {
            AbstractButton b = e.nextElement();
            if (!b.isSelected()) continue;
            openType = OpenType.valueOf(b.getName());
            break;
        }
        VideoArchiveDAO dao = this.toolBelt.getAnnotationDAOFactory().newVideoArchiveDAO();
        dao.startTransaction();
        switch (8.$SwitchMap$vars$annotation$ui$dialogs$OpenVideoArchiveDialog$OpenType[openType.ordinal()]) {
            case 1: {
                String videoArchiveName = this.getNameTextField().getText();
                int sequenceNumber = Integer.parseInt(this.getSequenceNumberByNameTextField().getText());
                String platform = (String)this.getCameraPlatformComboBox().getSelectedItem();
                videoArchive = dao.findOrCreateByParameters(platform, sequenceNumber, videoArchiveName);
                break;
            }
            case 2: {
                int sequenceNumber = Integer.parseInt(this.getSequenceNumberTextField().getText());
                String platform = (String)this.getCameraPlatformComboBox().getSelectedItem();
                int tapeNumber = Integer.parseInt(this.getTapeNumberTextField().getText());
                String postfix = this.getHdCheckBox().isSelected() ? "HD" : null;
                String videoArchiveName = PersistenceController.makeVideoArchiveName(platform, sequenceNumber, tapeNumber, postfix);
                videoArchive = dao.findOrCreateByParameters(platform, sequenceNumber, videoArchiveName);
                break;
            }
            case 3: {
                String name = (String)this.getExistingNamesComboBox().getSelectedItem();
                videoArchive = dao.findByName(name);
                break;
            }
        }
        dao.endTransaction();
        return videoArchive;
    }

    private JTextField getSequenceNumberByNameTextField() {
        if (this.sequenceNumberByNameTextField == null) {
            this.sequenceNumberByNameTextField = new JTextField();
            this.sequenceNumberByNameTextField.setColumns(10);
            this.sequenceNumberByNameTextField.addKeyListener((KeyListener)new NonDigitConsumingKeyListener());
            this.sequenceNumberByNameTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        OpenVideoArchiveDialog.this.getOkayButton().doClick();
                    }
                    super.keyReleased(e);
                }
            });
        }
        return this.sequenceNumberByNameTextField;
    }

    class SelectedRBItemListener
    implements ItemListener {
        SelectedRBItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                JRadioButton radioButton = (JRadioButton)e.getItemSelectable();
                OpenType openType = OpenType.valueOf(radioButton.getName());
                boolean cameraPlatformCB = false;
                boolean sequenceNumberTF = false;
                boolean hdChckB = false;
                boolean nameTF = false;
                boolean existingNamesCB = false;
                boolean tapeNumberTF = false;
                boolean cameraPlatformByNameCB = false;
                boolean sequenceNumberByNameTF = false;
                switch (openType) {
                    case BY_NAME: {
                        nameTF = true;
                        cameraPlatformByNameCB = true;
                        sequenceNumberByNameTF = true;
                        break;
                    }
                    case BY_PARAMS: {
                        cameraPlatformCB = true;
                        sequenceNumberTF = true;
                        tapeNumberTF = true;
                        hdChckB = true;
                        break;
                    }
                    case EXISTING: {
                        existingNamesCB = true;
                        break;
                    }
                }
                OpenVideoArchiveDialog.this.getCameraPlatformComboBox().setEnabled(cameraPlatformCB);
                OpenVideoArchiveDialog.this.getSequenceNumberTextField().setEnabled(sequenceNumberTF);
                OpenVideoArchiveDialog.this.getHdCheckBox().setEnabled(hdChckB);
                OpenVideoArchiveDialog.this.getNameTextField().setEnabled(nameTF);
                OpenVideoArchiveDialog.this.getCameraPlatformByNameComboBox().setEnabled(cameraPlatformByNameCB);
                OpenVideoArchiveDialog.this.getSequenceNumberByNameTextField().setEnabled(sequenceNumberByNameTF);
                OpenVideoArchiveDialog.this.getExistingNamesComboBox().setEnabled(existingNamesCB);
                OpenVideoArchiveDialog.this.getTapeNumberTextField().setEnabled(tapeNumberTF);
            }
        }
    }

    private static enum OpenType {
        BY_PARAMS,
        BY_NAME,
        EXISTING;

    }
}

