/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.actions.AddNewRefNumPropAction;
import vars.shared.ui.FancyButton;

public class NewRefNumPropDialog
extends JDialog {
    private JButton btnCancel = null;
    private JButton btnOk = null;
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JPanel jPanel = null;
    private JTextField jTextField = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public NewRefNumPropDialog() {
        super((Frame)StateLookup.getAnnotationFrame(), true);
        this.initialize();
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new FancyButton();
            this.btnCancel.setText("Cancel");
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewRefNumPropDialog.this.dispose();
                }
            });
        }
        return this.btnCancel;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new FancyButton();
            this.btnOk.setText("OK");
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        AddNewRefNumPropAction.setRefNumber(Integer.parseInt(NewRefNumPropDialog.this.getJTextField().getText()));
                    }
                    catch (Exception ex) {
                        NewRefNumPropDialog.this.log.warn("Unable to convert the contents of the dialog to an integer.");
                    }
                    NewRefNumPropDialog.this.dispose();
                }
            });
        }
        return this.btnOk;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.jContentPane, 1));
            this.jContentPane.add((Component)this.getJLabel(), null);
            this.jContentPane.add((Component)this.getJTextField(), null);
            this.jContentPane.add((Component)this.getJPanel(), null);
        }
        return this.jContentPane;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("Enter a Reference Number");
            this.jLabel.setHorizontalAlignment(2);
            this.jLabel.setHorizontalTextPosition(2);
        }
        return this.jLabel;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.add((Component)this.getBtnOk(), null);
            this.jPanel.add((Component)this.getBtnCancel(), null);
        }
        return this.jPanel;
    }

    private JTextField getJTextField() {
        if (this.jTextField == null) {
            this.jTextField = new JTextField();
            this.jTextField.setPreferredSize(new Dimension(80, 19));
            this.jTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    char c = e.getKeyChar();
                    if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
                        NewRefNumPropDialog.this.getToolkit().beep();
                        e.consume();
                    }
                }
            });
        }
        return this.jTextField;
    }

    private void initialize() {
        this.setSize(250, 100);
        this.setContentPane(this.getJContentPane());
        this.setTitle("VARS - Input");
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            JTextField tf = this.getJTextField();
            tf.setText(AddNewRefNumPropAction.getRefNumber() + "");
            tf.setRequestFocusEnabled(true);
            tf.requestFocus();
        }
    }

    @Override
    @Deprecated
    public void show() {
        this.setVisible(true);
    }
}

