/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.dialogs;

import foxtrot.Task;
import foxtrot.Worker;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.actions.AddPropertyAction;
import vars.annotation.ui.actions.AddSamplePropAction;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.ConceptNameTypes;
import vars.knowledgebase.SimpleConceptBean;
import vars.knowledgebase.SimpleConceptNameBean;
import vars.shared.ui.HierachicalConceptNameComboBox;
import vars.shared.ui.dialogs.StandardDialog;

public class AddSamplePropDialog
extends StandardDialog {
    private JComboBox comboBox;
    private JLabel lblSampleId;
    private JLabel lblSampledBy;
    private JPanel panel;
    private JTextField textField;
    private final ToolBelt toolBelt;

    public AddSamplePropDialog(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        this.initialize();
    }

    private JComboBox getComboBox() {
        if (this.comboBox == null) {
            Concept concept;
            try {
                concept = (Concept)Worker.post((Task)new Task(){

                    public Object run() throws Exception {
                        Concept c = AddSamplePropDialog.this.toolBelt.getAnnotationPersistenceService().findConceptByName("equipment");
                        if (c == null) {
                            c = AddSamplePropDialog.this.toolBelt.getAnnotationPersistenceService().findRootConcept();
                        }
                        return c;
                    }
                });
            }
            catch (Exception e) {
                SimpleConceptNameBean cn = new SimpleConceptNameBean("object", ConceptNameTypes.PRIMARY.getName());
                concept = new SimpleConceptBean((ConceptName)cn);
            }
            this.comboBox = new HierachicalConceptNameComboBox(concept, this.toolBelt.getAnnotationPersistenceService());
            this.comboBox.setFocusable(true);
            this.comboBox.setRequestFocusEnabled(true);
            this.comboBox.setSelectedItem("equipment");
        }
        return this.comboBox;
    }

    private JLabel getLblSampleId() {
        if (this.lblSampleId == null) {
            this.lblSampleId = new JLabel("Sample ID");
        }
        return this.lblSampleId;
    }

    private JLabel getLblSampledBy() {
        if (this.lblSampledBy == null) {
            this.lblSampledBy = new JLabel("Sampled By");
        }
        return this.lblSampledBy;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            GroupLayout groupLayout = new GroupLayout(this.panel);
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getLblSampledBy()).addComponent(this.getLblSampleId())).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getTextField(), -1, 361, Short.MAX_VALUE).addComponent(this.getComboBox(), 0, 361, Short.MAX_VALUE)).addContainerGap()));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblSampledBy()).addComponent(this.getComboBox(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblSampleId()).addComponent(this.getTextField(), -2, -1, -2)).addContainerGap(0, Short.MAX_VALUE)));
            this.panel.setLayout(groupLayout);
        }
        return this.panel;
    }

    private JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField();
            this.textField.setColumns(10);
            this.textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (10 == e.getKeyCode()) {
                        AddSamplePropDialog.this.getOkayButton().doClick();
                    }
                }
            });
        }
        return this.textField;
    }

    private void initialize() {
        this.setTitle("VARS - Add Sample Reference");
        this.setResizable(false);
        this.getContentPane().add((Component)this.getPanel(), "Center");
        this.setLocationRelativeTo(null);
        this.getOkayButton().addActionListener(new ActionListener(){
            AddPropertyAction action1;
            AddPropertyAction action2;
            {
                this.action1 = new AddSamplePropAction(AddSamplePropDialog.this.toolBelt);
                this.action2 = new AddPropertyAction(AddSamplePropDialog.this.toolBelt, "sample-reference", "self", "0");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.action1.setToConcept((String)AddSamplePropDialog.this.getComboBox().getSelectedItem());
                this.action1.doAction();
                String text = AddSamplePropDialog.this.getTextField().getText();
                if (!text.equals("")) {
                    this.action2.setLinkValue(text);
                    this.action2.doAction();
                }
                AddSamplePropDialog.this.getTextField().setText("");
                AddSamplePropDialog.this.getComboBox().getEditor().selectAll();
                AddSamplePropDialog.this.dispose();
            }
        });
        this.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddSamplePropDialog.this.dispose();
            }
        });
        this.pack();
    }

    public void setVisible(boolean b) {
        if (b) {
            JComboBox cb = this.getComboBox();
            cb.requestFocus();
            cb.getEditor().selectAll();
        }
        super.setVisible(b);
    }
}

