/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import vars.annotation.ui.StateLookup;
import vars.shared.ui.dialogs.StandardDialog;

public class AddCommentAssociationDialog
extends StandardDialog {
    private JScrollPane scrollPane;
    private Status status;
    private JTextField textField;

    public AddCommentAssociationDialog() {
        this(StateLookup.getAnnotationFrame());
    }

    public AddCommentAssociationDialog(Frame parent) {
        super(parent);
        try {
            this.initialize();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.status = Status.Cancel;
    }

    public String getComment() {
        return this.getTextField().getText();
    }

    protected JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setHorizontalScrollBarPolicy(32);
            this.scrollPane.setViewportView(this.getTextField());
        }
        return this.scrollPane;
    }

    public Status getStatus() {
        return this.status;
    }

    public JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField();
            Dimension size = this.textField.getPreferredSize();
            this.textField.setPreferredSize(new Dimension(350, size.height));
        }
        return this.textField;
    }

    private void initialize() throws Exception {
        this.setModal(true);
        this.setTitle("VARS - Enter Comment");
        this.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddCommentAssociationDialog.this.setVisible(false);
                AddCommentAssociationDialog.this.status = Status.Cancel;
            }
        });
        this.getRootPane().setDefaultButton(this.getOkayButton());
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (4L == (4L & e.getChangeFlags())) {
                    AddCommentAssociationDialog.this.getRootPane().setDefaultButton(AddCommentAssociationDialog.this.getOkayButton());
                }
            }
        });
        this.getContentPane().add((Component)this.getScrollPane(), "Center");
        this.pack();
    }

    public static void main(String[] args) {
        try {
            AddCommentAssociationDialog dialog = new AddCommentAssociationDialog();
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setComment(String comment) {
        this.getTextField().setText(comment);
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.getTextField().requestFocusInWindow();
        }
    }

    public static enum Status {
        OK,
        Cancel;

    }
}

