/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import org.bushe.swing.event.EventBus;
import vars.VARSException;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.VideoArchiveChangedEvent;

public class RenameVideoArchiveCmd
implements Command {
    private final String oldName;
    private final String newName;
    private boolean newNameApplied = false;

    public RenameVideoArchiveCmd(String oldName, String newName) {
        this.oldName = oldName;
        this.newName = newName;
    }

    @Override
    public void apply(ToolBelt toolBelt) {
        if (!this.newNameApplied) {
            this.doCommand(toolBelt, this.oldName, this.newName);
        }
    }

    @Override
    public void unapply(ToolBelt toolBelt) {
        if (this.newNameApplied) {
            this.doCommand(toolBelt, this.newName, this.oldName);
        }
    }

    private void doCommand(ToolBelt toolBelt, String from, String to) {
        VideoArchiveDAO videoArchiveDAO = toolBelt.getAnnotationDAOFactory().newVideoArchiveDAO();
        videoArchiveDAO.startTransaction();
        VideoArchive newVideoArchive = videoArchiveDAO.findByName(to);
        if (newVideoArchive == null) {
            VideoArchive oldVideoArchive = videoArchiveDAO.findByName(from);
            if (oldVideoArchive != null) {
                oldVideoArchive.setName(to);
                videoArchiveDAO.endTransaction();
                videoArchiveDAO.close();
                this.newNameApplied = !this.newNameApplied;
                EventBus.publish((Object)new VideoArchiveChangedEvent((Object)null, oldVideoArchive));
            } else {
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("Unable to find a VideoArchive named " + from + " in the database"));
            }
        } else {
            videoArchiveDAO.endTransaction();
            videoArchiveDAO.close();
            throw new VARSException("Unable to rename the VideoArchive from " + from + " to " + to + ". A VideoArchive named " + to + " already exists.");
        }
    }

    @Override
    public String getDescription() {
        return "Rename a VideoArchive from " + this.oldName + " to " + this.newName;
    }
}

