/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.bushe.swing.event.EventBus;
import vars.annotation.Observation;
import vars.annotation.ObservationDAO;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.ObservationsChangedEvent;

public class RenameObservationsCmd
implements Command {
    private final String newConceptName;
    private final String user;
    private final Collection<DataBean> originalData = new ArrayList<DataBean>();

    public RenameObservationsCmd(String newConceptName, String user, Collection<Observation> observations) {
        this.newConceptName = newConceptName;
        this.user = user;
        for (Observation observation : observations) {
            this.originalData.add(new DataBean(observation.getPrimaryKey(), observation));
        }
    }

    @Override
    public void apply(ToolBelt toolBelt) {
        ArrayList<Observation> modifiedObservations = new ArrayList<Observation>();
        String conceptName = toolBelt.getPersistenceController().getValidatedConceptName(this.newConceptName);
        ObservationDAO observationDAO = toolBelt.getAnnotationDAOFactory().newObservationDAO();
        observationDAO.startTransaction();
        for (DataBean bean : this.originalData) {
            Observation observation = observationDAO.findByPrimaryKey(bean.primaryKey);
            if (observation == null) continue;
            observation.setConceptName(conceptName);
            observation.setObserver(this.user);
            modifiedObservations.add(observation);
        }
        observationDAO.endTransaction();
        observationDAO.close();
        EventBus.publish((Object)new ObservationsChangedEvent((Object)null, (Collection<Observation>)modifiedObservations));
    }

    @Override
    public void unapply(ToolBelt toolBelt) {
        ArrayList<Observation> modifiedObservations = new ArrayList<Observation>();
        ObservationDAO observationDAO = toolBelt.getAnnotationDAOFactory().newObservationDAO();
        observationDAO.startTransaction();
        for (DataBean bean : this.originalData) {
            Observation observation = observationDAO.findByPrimaryKey(bean.primaryKey);
            if (observation == null) continue;
            observation.setConceptName(bean.originalObservation.getConceptName());
            observation.setObserver(bean.originalObservation.getObserver());
            modifiedObservations.add(observation);
        }
        observationDAO.endTransaction();
        observationDAO.close();
        EventBus.publish((Object)new ObservationsChangedEvent((Object)null, (Collection<Observation>)modifiedObservations));
    }

    @Override
    public String getDescription() {
        return "Rename " + this.originalData.size() + " Observations to " + this.newConceptName;
    }

    private class DataBean {
        final Object primaryKey;
        final Observation originalObservation;

        private DataBean(Object primaryKey, Observation originalObservation) {
            this.primaryKey = primaryKey;
            this.originalObservation = originalObservation;
        }
    }
}

