/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import org.bushe.swing.event.EventBus;
import vars.DAO;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.Observation;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.VideoFrame;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.ObservationsAddedEvent;
import vars.annotation.ui.eventbus.ObservationsRemovedEvent;

public class RemoveObservationsCmd
implements Command {
    private final Collection<DataBean> deletedData = new ArrayList<DataBean>();

    public RemoveObservationsCmd(Collection<Observation> originalObservations) {
        for (Observation observation : originalObservations) {
            this.deletedData.add(new DataBean(observation));
        }
    }

    @Override
    public void apply(ToolBelt toolBelt) {
        DAO dao = toolBelt.getAnnotationDAOFactory().newDAO();
        dao.startTransaction();
        for (DataBean bean : this.deletedData) {
            Observation observation = (Observation)dao.find((Object)bean.observation);
            if (observation == null) continue;
            VideoFrame videoFrame = observation.getVideoFrame();
            videoFrame.removeObservation(observation);
            dao.remove((Object)observation);
            if (videoFrame.getObservations().size() != 0) continue;
            VideoArchive videoArchive = videoFrame.getVideoArchive();
            videoArchive.removeVideoFrame(videoFrame);
            dao.remove((Object)videoFrame);
        }
        dao.endTransaction();
        dao.close();
        ArrayList<Observation> removedObservations = new ArrayList<Observation>(Collections2.transform(this.deletedData, (Function)new Function<DataBean, Observation>(){

            public Observation apply(DataBean input) {
                return input.observation;
            }
        }));
        EventBus.publish((Object)new ObservationsRemovedEvent((Object)null, (Collection<Observation>)removedObservations));
    }

    @Override
    public void unapply(ToolBelt toolBelt) {
        AnnotationDAOFactory daoFactory = toolBelt.getAnnotationDAOFactory();
        DAO dao = daoFactory.newDAO();
        VideoArchiveDAO videoArchiveDAO = daoFactory.newVideoArchiveDAO(dao.getEntityManager());
        dao.startTransaction();
        for (DataBean bean : this.deletedData) {
            VideoArchive videoArchive = videoArchiveDAO.findByName(bean.videoArchiveName);
            if (videoArchive == null) continue;
            VideoFrame videoFrame = videoArchive.findVideoFrameByTimeCode(bean.videoFrame.getTimecode());
            if (videoFrame == null) {
                videoFrame = bean.videoFrame;
                videoArchive.addVideoFrame(bean.videoFrame);
            }
            videoFrame.addObservation(bean.observation);
        }
        dao.endTransaction();
        dao.close();
        ArrayList<Observation> addedObservations = new ArrayList<Observation>(Collections2.transform(this.deletedData, (Function)new Function<DataBean, Observation>(){

            public Observation apply(DataBean input) {
                return input.observation;
            }
        }));
        EventBus.publish((Object)new ObservationsAddedEvent((Object)null, (Collection<Observation>)addedObservations));
    }

    @Override
    public String getDescription() {
        return "Delete " + this.deletedData.size() + " observations";
    }

    private class DataBean {
        private final String videoArchiveName;
        private final VideoFrame videoFrame;
        private final Observation observation;

        private DataBean(Observation observation) {
            this.observation = observation;
            this.videoFrame = observation.getVideoFrame();
            this.videoArchiveName = this.videoFrame.getVideoArchive().getName();
        }
    }
}

