/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.bushe.swing.event.EventBus;
import vars.annotation.Observation;
import vars.annotation.ObservationDAO;
import vars.annotation.VideoFrame;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.VideoFramesChangedEvent;

public class RemoveImageReferencesCmd
implements Command {
    private final Collection<DataBean> originalData = new ArrayList<DataBean>();

    public RemoveImageReferencesCmd(Collection<Observation> observations) {
        for (Observation observation : observations) {
            this.originalData.add(new DataBean(observation.getVideoFrame().getCameraData().getImageReference(), observation.getPrimaryKey()));
        }
    }

    @Override
    public void apply(ToolBelt toolBelt) {
        HashSet<VideoFrame> videoFrames = new HashSet<VideoFrame>(this.originalData.size());
        ObservationDAO dao = toolBelt.getAnnotationDAOFactory().newObservationDAO();
        dao.startTransaction();
        for (DataBean bean : this.originalData) {
            Observation newObs = dao.findByPrimaryKey(bean.observationPrimaryKey);
            newObs.getVideoFrame().getCameraData().setImageReference(null);
            videoFrames.add(newObs.getVideoFrame());
        }
        dao.endTransaction();
        dao.close();
        EventBus.publish((Object)new VideoFramesChangedEvent((Object)null, (Collection<VideoFrame>)videoFrames));
    }

    @Override
    public void unapply(ToolBelt toolBelt) {
        HashSet<VideoFrame> videoFrames = new HashSet<VideoFrame>(this.originalData.size());
        ObservationDAO dao = toolBelt.getAnnotationDAOFactory().newObservationDAO();
        dao.startTransaction();
        for (DataBean bean : this.originalData) {
            Observation observation = dao.findByPrimaryKey(bean.observationPrimaryKey);
            if (observation == null) continue;
            observation.getVideoFrame().getCameraData().setImageReference(bean.imageReference);
            videoFrames.add(observation.getVideoFrame());
        }
        dao.endTransaction();
        dao.close();
        EventBus.publish((Object)new VideoFramesChangedEvent((Object)null, (Collection<VideoFrame>)videoFrames));
    }

    @Override
    public String getDescription() {
        return "Remove image references from " + this.originalData.size() + " observations";
    }

    private class DataBean {
        final String imageReference;
        final Object observationPrimaryKey;

        private DataBean(String imageReference, Object observationPrimaryKey) {
            this.imageReference = imageReference;
            this.observationPrimaryKey = observationPrimaryKey;
        }
    }
}

