/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.bushe.swing.event.EventBus;
import vars.ILink;
import vars.annotation.AnnotationFactory;
import vars.annotation.Association;
import vars.annotation.AssociationDAO;
import vars.annotation.Observation;
import vars.annotation.ObservationDAO;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.ObservationsChangedEvent;

public class RemoveAssociationsCmd
implements Command {
    private final Collection<DataBean> originalData = new ArrayList<DataBean>();

    public RemoveAssociationsCmd(Collection<Association> originalAssociations) {
        for (Association association : originalAssociations) {
            this.originalData.add(new DataBean(association, association.getPrimaryKey(), association.getObservation().getPrimaryKey()));
        }
    }

    @Override
    public void apply(ToolBelt toolBelt) {
        ArrayList<Observation> modifiedObservations = new ArrayList<Observation>();
        AssociationDAO dao = toolBelt.getAnnotationDAOFactory().newAssociationDAO();
        dao.startTransaction();
        for (DataBean bean : this.originalData) {
            Association association = dao.findByPrimaryKey(bean.associationPrimaryKey);
            if (association == null) continue;
            Observation observation = association.getObservation();
            observation.removeAssociation(association);
            dao.remove((Object)association);
            modifiedObservations.add(observation);
        }
        dao.endTransaction();
        dao.close();
        EventBus.publish((Object)new ObservationsChangedEvent((Object)null, (Collection<Observation>)modifiedObservations));
    }

    @Override
    public void unapply(ToolBelt toolBelt) {
        ArrayList<Observation> modifiedObservations = new ArrayList<Observation>();
        AnnotationFactory factory = toolBelt.getAnnotationFactory();
        ObservationDAO observationDAO = toolBelt.getAnnotationDAOFactory().newObservationDAO();
        AssociationDAO associationDAO = toolBelt.getAnnotationDAOFactory().newAssociationDAO(observationDAO.getEntityManager());
        for (DataBean bean : this.originalData) {
            Observation observation = observationDAO.findByPrimaryKey(bean.originalObservationPrimaryKey);
            if (observation == null) continue;
            Association association = factory.newAssociation((ILink)bean.originalAssociation);
            observation.addAssociation(association);
            associationDAO.persist((Object)association);
            modifiedObservations.add(observation);
        }
        observationDAO.endTransaction();
        observationDAO.close();
        EventBus.publish((Object)new ObservationsChangedEvent((Object)null, (Collection<Observation>)modifiedObservations));
    }

    @Override
    public String getDescription() {
        return "Delete " + this.originalData.size() + " associations";
    }

    private class DataBean {
        final Object associationPrimaryKey;
        final Object originalObservationPrimaryKey;
        final Association originalAssociation;

        private DataBean(Association originalAssociation, Object associationPrimaryKey, Object originalObservationPrimaryKey) {
            this.originalAssociation = originalAssociation;
            this.associationPrimaryKey = associationPrimaryKey;
            this.originalObservationPrimaryKey = originalObservationPrimaryKey;
        }
    }
}

