/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.bushe.swing.event.EventBus;
import vars.annotation.Observation;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.VideoFrame;
import vars.annotation.VideoFrameDAO;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.VideoArchiveChangedEvent;
import vars.annotation.ui.eventbus.VideoFramesChangedEvent;

public class MoveVideoFramesCmd
implements Command {
    private final String targetVideoArchiveName;
    private final Collection<DataBean> originalData = new ArrayList<DataBean>();
    private final boolean refreshVideoArchive;

    public MoveVideoFramesCmd(String targetVideoArchiveName, Collection<VideoFrame> originalVideoFrames) {
        this(targetVideoArchiveName, originalVideoFrames, false);
    }

    public MoveVideoFramesCmd(String targetVideoArchiveName, Collection<VideoFrame> originalVideoFrames, boolean refreshVideoArchive) {
        if (targetVideoArchiveName == null || originalVideoFrames == null) {
            throw new IllegalArgumentException("null parameters are not allowed in the constructor");
        }
        this.refreshVideoArchive = refreshVideoArchive;
        this.targetVideoArchiveName = targetVideoArchiveName;
        for (VideoFrame videoFrame : originalVideoFrames) {
            this.originalData.add(new DataBean(videoFrame.getVideoArchive().getName(), videoFrame.getPrimaryKey()));
        }
    }

    @Override
    public void apply(ToolBelt toolBelt) {
        ArrayList<VideoFrame> modifiedVideoFrames = new ArrayList<VideoFrame>(this.originalData.size());
        VideoArchiveDAO dao = toolBelt.getAnnotationDAOFactory().newVideoArchiveDAO();
        VideoFrameDAO videoFrameDao = toolBelt.getAnnotationDAOFactory().newVideoFrameDAO(dao.getEntityManager());
        dao.startTransaction();
        VideoArchive videoArchive = dao.findByName(this.targetVideoArchiveName);
        for (DataBean bean : this.originalData) {
            VideoFrame videoFrame = videoFrameDao.findByPrimaryKey(bean.videoFramePrimaryKey);
            VideoArchive sourceVideoArchive = videoFrame.getVideoArchive();
            if (sourceVideoArchive == null || sourceVideoArchive.getName().equals(videoArchive.getName())) continue;
            sourceVideoArchive.removeVideoFrame(videoFrame);
            VideoFrame targetVideoFrame = videoArchive.findVideoFrameByTimeCode(videoFrame.getTimecode());
            if (targetVideoFrame != null) {
                this.mergeFrames(videoFrame, targetVideoFrame);
                dao.remove((Object)videoFrame);
                modifiedVideoFrames.add(targetVideoFrame);
                continue;
            }
            videoArchive.addVideoFrame(videoFrame);
            modifiedVideoFrames.add(videoFrame);
        }
        dao.endTransaction();
        EventBus.publish((Object)new VideoFramesChangedEvent((Object)null, (Collection<VideoFrame>)modifiedVideoFrames));
        if (this.refreshVideoArchive) {
            VideoArchive va = StateLookup.getVideoArchive();
            va = (VideoArchive)dao.find((Object)va);
            EventBus.publish((Object)new VideoArchiveChangedEvent((Object)this, va));
        }
    }

    @Override
    public void unapply(ToolBelt toolBelt) {
        ArrayList<VideoFrame> modifiedVideoFrames = new ArrayList<VideoFrame>(this.originalData.size());
        VideoArchiveDAO dao = toolBelt.getAnnotationDAOFactory().newVideoArchiveDAO();
        VideoFrameDAO videoFrameDao = toolBelt.getAnnotationDAOFactory().newVideoFrameDAO(dao.getEntityManager());
        dao.startTransaction();
        for (DataBean bean : this.originalData) {
            VideoFrame videoFrame;
            VideoArchive sourceVideoArchive;
            VideoArchive videoArchive = dao.findByName(bean.originalVideoArchiveName);
            if (videoArchive == null || (sourceVideoArchive = (videoFrame = videoFrameDao.findByPrimaryKey(bean.videoFramePrimaryKey)).getVideoArchive()) == null || sourceVideoArchive.getName().equals(videoArchive.getName())) continue;
            sourceVideoArchive.removeVideoFrame(videoFrame);
            VideoFrame targetVideoFrame = videoArchive.findVideoFrameByTimeCode(videoFrame.getTimecode());
            if (targetVideoFrame != null) {
                this.mergeFrames(videoFrame, targetVideoFrame);
                dao.remove((Object)videoFrame);
                modifiedVideoFrames.add(targetVideoFrame);
                continue;
            }
            videoArchive.addVideoFrame(videoFrame);
            modifiedVideoFrames.add(videoFrame);
        }
        dao.endTransaction();
        EventBus.publish((Object)new VideoFramesChangedEvent((Object)null, (Collection<VideoFrame>)modifiedVideoFrames));
        if (this.refreshVideoArchive) {
            VideoArchive va = StateLookup.getVideoArchive();
            va = (VideoArchive)dao.find((Object)va);
            EventBus.publish((Object)new VideoArchiveChangedEvent((Object)this, va));
        }
    }

    @Override
    public String getDescription() {
        return "Move " + this.originalData.size() + " VideoFrames to VideoArchive named " + this.targetVideoArchiveName;
    }

    private void mergeFrames(VideoFrame sourceFrame, VideoFrame targetFrame) {
        ArrayList observations = new ArrayList(sourceFrame.getObservations());
        for (Observation observation : observations) {
            sourceFrame.removeObservation(observation);
            targetFrame.addObservation(observation);
        }
        String sourceImageRef = sourceFrame.getCameraData().getImageReference();
        String targetImageRef = targetFrame.getCameraData().getImageReference();
        if (targetImageRef == null && sourceImageRef != null) {
            targetFrame.getCameraData().setImageReference(sourceImageRef);
        }
    }

    private class DataBean {
        String originalVideoArchiveName;
        Object videoFramePrimaryKey;

        private DataBean(String originalVideoArchiveName, Object videoFramePrimaryKey) {
            this.originalVideoArchiveName = originalVideoArchiveName;
            this.videoFramePrimaryKey = videoFramePrimaryKey;
        }
    }
}

