/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bushe.swing.event.EventBus;
import vars.annotation.Observation;
import vars.annotation.ObservationDAO;
import vars.annotation.jpa.ObservationImpl;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.ObservationsChangedEvent;

public class EditNotesCmd
implements Command {
    private final String newNote;
    private final String oldNote;
    private final Long observationId;

    public EditNotesCmd(String newNote, String oldNote, Long observationId) {
        this.newNote = newNote;
        this.oldNote = oldNote;
        this.observationId = observationId;
    }

    @Override
    public void apply(ToolBelt toolBelt) {
        this.doCommand(toolBelt, true);
    }

    private void doCommand(ToolBelt toolBelt, boolean isApply) {
        ObservationDAO dao = toolBelt.getAnnotationDAOFactory().newObservationDAO();
        dao.startTransaction();
        Observation observation = (Observation)dao.findByPrimaryKey(ObservationImpl.class, (Object)this.observationId);
        ObservationsChangedEvent updateEvent = null;
        if (observation != null) {
            String note = isApply ? this.newNote : this.oldNote;
            observation.setNotes(note);
            List<Observation> changedObservations = Collections.singletonList(observation);
            updateEvent = new ObservationsChangedEvent((Object)null, (Collection<Observation>)changedObservations);
        }
        dao.endTransaction();
        dao.close();
        if (updateEvent != null) {
            EventBus.publish(updateEvent);
        }
    }

    @Override
    public void unapply(ToolBelt toolBelt) {
        this.doCommand(toolBelt, false);
    }

    @Override
    public String getDescription() {
        return "Change notes for Observation[id = " + this.observationId + "] from " + this.oldNote + " to " + this.newNote;
    }
}

