/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.bushe.swing.event.EventBus;
import vars.DAO;
import vars.annotation.AnnotationFactory;
import vars.annotation.Observation;
import vars.annotation.VideoFrame;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.ObservationsAddedEvent;
import vars.annotation.ui.eventbus.ObservationsRemovedEvent;
import vars.annotation.ui.eventbus.ObservationsSelectedEvent;

public class DuplicateObservationsCmd
implements Command {
    private final String user;
    private final Collection<Observation> sourceObservations;
    private final Collection<Observation> duplicateObservations = Collections.synchronizedCollection(new ArrayList());
    private final boolean selectObservations;

    public DuplicateObservationsCmd(String user, Collection<Observation> sourceObservations, boolean selectObservations) {
        if (user == null || sourceObservations == null) {
            throw new IllegalArgumentException("Command arguments can not be null");
        }
        this.user = user;
        this.sourceObservations = new ArrayList<Observation>(sourceObservations);
        this.selectObservations = selectObservations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(ToolBelt toolBelt) {
        AnnotationFactory annotationFactory = toolBelt.getAnnotationFactory();
        Date observationDate = new Date();
        Collection<Observation> collection = this.duplicateObservations;
        synchronized (collection) {
            DAO dao = toolBelt.getAnnotationDAOFactory().newDAO();
            dao.startTransaction();
            for (Observation observation : this.sourceObservations) {
                observation = (Observation)dao.find((Object)observation);
                VideoFrame videoFrame = observation.getVideoFrame();
                Observation newObservation = annotationFactory.newObservation();
                newObservation.setConceptName(observation.getConceptName());
                newObservation.setObservationDate(observationDate);
                newObservation.setObserver(this.user);
                videoFrame.addObservation(newObservation);
                dao.persist((Object)newObservation);
                this.duplicateObservations.add(newObservation);
            }
            dao.endTransaction();
        }
        EventBus.publish((Object)new ObservationsAddedEvent((Object)null, this.duplicateObservations));
        if (this.selectObservations) {
            EventBus.publish((Object)new ObservationsSelectedEvent((Object)null, this.duplicateObservations));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unapply(ToolBelt toolBelt) {
        ArrayList<Observation> deletedObservations = new ArrayList<Observation>(this.duplicateObservations);
        Collection<Observation> collection = this.duplicateObservations;
        synchronized (collection) {
            DAO dao = toolBelt.getAnnotationDAOFactory().newDAO();
            dao.startTransaction();
            for (Observation observation : this.duplicateObservations) {
                deletedObservations.add(observation);
                observation = (Observation)dao.find((Object)observation);
                VideoFrame videoFrame = observation.getVideoFrame();
                videoFrame.removeObservation(observation);
                dao.remove((Object)observation);
                if (videoFrame.getObservations().size() != 0) continue;
                dao.remove((Object)videoFrame);
            }
            dao.endTransaction();
            this.duplicateObservations.clear();
        }
        EventBus.publish((Object)new ObservationsRemovedEvent((Object)null, (Collection<Observation>)deletedObservations));
    }

    @Override
    public String getDescription() {
        return "Duplicate " + this.sourceObservations.size() + " observations";
    }
}

