/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.bushe.swing.event.EventBus;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.time.Timecode;
import vars.DAO;
import vars.annotation.AnnotationFactory;
import vars.annotation.AnnotationPersistenceService;
import vars.annotation.Association;
import vars.annotation.CameraDirections;
import vars.annotation.Observation;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.VideoFrame;
import vars.annotation.VideoFrameDAO;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.ObservationsAddedEvent;
import vars.annotation.ui.eventbus.ObservationsRemovedEvent;
import vars.annotation.ui.eventbus.ObservationsSelectedEvent;

public class CopyObservationsCmd
implements Command {
    private final Collection<Observation> sourceObservations;
    private final String videoArchiveName;
    private final VideoIndex videoIndex;
    private final String user;
    private final Collection<Observation> copyObservations = Collections.synchronizedCollection(new ArrayList());
    private final boolean selectAddedObservations;

    public CopyObservationsCmd(String videoArchiveName, VideoIndex videoIndex, String user, Collection<Observation> sourceObservations, boolean selectObservations) {
        if (videoArchiveName == null || videoIndex == null || sourceObservations == null) {
            throw new IllegalArgumentException("Command arguments can not be null");
        }
        this.sourceObservations = new ArrayList<Observation>(sourceObservations);
        this.videoArchiveName = videoArchiveName;
        this.videoIndex = videoIndex;
        this.user = user;
        this.selectAddedObservations = selectObservations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(ToolBelt toolBelt) {
        AnnotationFactory annotationFactory = toolBelt.getAnnotationFactory();
        AnnotationPersistenceService annotationPersistenceService = toolBelt.getAnnotationPersistenceService();
        DAO dao = toolBelt.getAnnotationDAOFactory().newDAO();
        VideoArchiveDAO videoArchiveDAO = toolBelt.getAnnotationDAOFactory().newVideoArchiveDAO(dao.getEntityManager());
        VideoFrameDAO videoFrameDAO = toolBelt.getAnnotationDAOFactory().newVideoFrameDAO(dao.getEntityManager());
        dao.startTransaction();
        VideoArchive videoArchive = videoArchiveDAO.findByName(this.videoArchiveName);
        if (videoArchive != null) {
            Timecode timecode = (Timecode)this.videoIndex.getTimecode().get();
            Long id = annotationPersistenceService.findTimeCodeByVideoArchiveName(timecode.toString(), this.videoArchiveName);
            VideoFrame videoFrame = null;
            if (id != null) {
                videoFrame = videoFrameDAO.findByPrimaryKey((Object)id);
            }
            if (videoFrame == null) {
                VideoFrame fVideoFrame = videoFrame = annotationFactory.newVideoFrame();
                this.videoIndex.getTimecode().ifPresent(tc -> fVideoFrame.setTimecode(tc.toString()));
                this.videoIndex.getTimestamp().ifPresent(ts -> fVideoFrame.setRecordedDate(Date.from(ts)));
                CameraDirections cameraDirections = StateLookup.getCameraDirection();
                videoFrame.getCameraData().setDirection(cameraDirections.getDirection());
                videoArchive.addVideoFrame(videoFrame);
                dao.persist((Object)videoFrame);
            }
            Date date = new Date();
            Collection<Observation> collection = this.copyObservations;
            synchronized (collection) {
                for (Observation observation : this.sourceObservations) {
                    Observation copyObservation = annotationFactory.newObservation();
                    copyObservation.setObserver(this.user);
                    copyObservation.setObservationDate(date);
                    copyObservation.setConceptName(observation.getConceptName());
                    videoFrame.addObservation(copyObservation);
                    dao.persist((Object)copyObservation);
                    for (Association association : new ArrayList(observation.getAssociations())) {
                        Association copyAssociation = annotationFactory.newAssociation();
                        copyAssociation.setLinkName(association.getLinkName());
                        copyAssociation.setLinkValue(association.getLinkValue());
                        copyAssociation.setToConcept(association.getToConcept());
                        copyObservation.addAssociation(copyAssociation);
                    }
                    this.copyObservations.add(copyObservation);
                }
            }
            dao.endTransaction();
            EventBus.publish((Object)new ObservationsAddedEvent((Object)null, this.copyObservations));
            if (this.selectAddedObservations) {
                EventBus.publish((Object)new ObservationsSelectedEvent((Object)null, this.copyObservations));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unapply(ToolBelt toolBelt) {
        ArrayList<Observation> droppedObservations = new ArrayList<Observation>(this.copyObservations);
        Collection<Observation> collection = this.copyObservations;
        synchronized (collection) {
            DAO dao = toolBelt.getAnnotationDAOFactory().newDAO();
            dao.startTransaction();
            for (Observation obs : this.copyObservations) {
                Observation observation = (Observation)dao.find((Object)obs);
                if (observation == null) continue;
                droppedObservations.add(obs);
                VideoFrame videoFrame = observation.getVideoFrame();
                videoFrame.removeObservation(observation);
                dao.remove((Object)observation);
                if (videoFrame.getObservations().size() != 0) continue;
                dao.remove((Object)videoFrame);
            }
            dao.endTransaction();
            this.copyObservations.clear();
        }
        EventBus.publish((Object)new ObservationsRemovedEvent((Object)null, (Collection<Observation>)droppedObservations));
    }

    @Override
    public String getDescription() {
        return "Copy " + this.sourceObservations.size() + " observations to " + this.videoArchiveName + " at " + this.videoIndex.getTimecode().map(Timecode::toString).orElse("NO TIMECODE");
    }
}

