/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import org.bushe.swing.event.EventBus;
import vars.annotation.VideoArchiveSet;
import vars.annotation.VideoArchiveSetDAO;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.VideoArchiveSetChangedEvent;

public class ChangeVideoArchiveSetCmd
implements Command {
    private final Object primaryKey;
    private final DataBean original;
    private final DataBean modified;

    public ChangeVideoArchiveSetCmd(String shipName, String platformName, char formatCode, VideoArchiveSet videoArchiveSet) {
        this.primaryKey = videoArchiveSet.getPrimaryKey();
        this.original = new DataBean(videoArchiveSet);
        this.modified = new DataBean(shipName, platformName, formatCode);
    }

    @Override
    public void apply(ToolBelt toolBelt) {
        this.doChange(toolBelt, true);
    }

    @Override
    public void unapply(ToolBelt toolBelt) {
        this.doChange(toolBelt, false);
    }

    private void doChange(ToolBelt toolBelt, boolean isApply) {
        DataBean values = isApply ? this.modified : this.original;
        VideoArchiveSetDAO dao = toolBelt.getAnnotationDAOFactory().newVideoArchiveSetDAO();
        dao.startTransaction();
        VideoArchiveSet vas = dao.findByPrimaryKey(this.primaryKey);
        vas.setShipName(values.shipName);
        vas.setPlatformName(values.platformName);
        vas.setFormatCode(values.formatCode);
        dao.endTransaction();
        dao.close();
        EventBus.publish((Object)new VideoArchiveSetChangedEvent((Object)null, vas));
    }

    @Override
    public String getDescription() {
        return "Change VideoArchiveSet properties to " + this.original.shipName + ", " + this.original.platformName + ", " + this.original.formatCode;
    }

    private class DataBean {
        final String shipName;
        final String platformName;
        final char formatCode;

        DataBean(VideoArchiveSet videoArchiveSet) {
            this(videoArchiveSet.getShipName(), videoArchiveSet.getPlatformName(), videoArchiveSet.getFormatCode());
        }

        DataBean(String shipName, String platformName, char formatCode) {
            this.shipName = shipName;
            this.platformName = platformName;
            this.formatCode = formatCode;
        }
    }
}

