/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import java.util.Collection;
import org.bushe.swing.event.EventBus;
import vars.annotation.AnnotationFactory;
import vars.annotation.CameraDeployment;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.VideoArchiveSet;
import vars.annotation.VideoArchiveSetDAO;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.VideoArchiveSetChangedEvent;

public class ChangeVideoArchiveNameCmd
implements Command {
    private final Object primaryKey;
    private final DataBean originalData;
    private final DataBean modifiedData;

    public ChangeVideoArchiveNameCmd(VideoArchive videoArchive, String newName, String newPlatformName, int newSequenceNumber) {
        this.primaryKey = videoArchive.getPrimaryKey();
        String platformName = videoArchive.getVideoArchiveSet().getPlatformName();
        int sequenceNumber = ((CameraDeployment)videoArchive.getVideoArchiveSet().getCameraDeployments().iterator().next()).getSequenceNumber();
        this.originalData = new DataBean(platformName, sequenceNumber, videoArchive.getName());
        this.modifiedData = new DataBean(newPlatformName, newSequenceNumber, newName);
    }

    @Override
    public void apply(ToolBelt toolBelt) {
        this.doCommand(toolBelt, true);
    }

    @Override
    public void unapply(ToolBelt toolBelt) {
        this.doCommand(toolBelt, false);
    }

    private void doCommand(ToolBelt toolBelt, boolean isApply) {
        DataBean data = isApply ? this.modifiedData : this.originalData;
        VideoArchiveDAO dao = toolBelt.getAnnotationDAOFactory().newVideoArchiveDAO();
        dao.startTransaction();
        VideoArchive matchingVideoArchive = dao.findByName(data.videoArchiveName);
        if (matchingVideoArchive != null) {
            DataBean oldData = isApply ? this.originalData : this.modifiedData;
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("A VideoArchive named " + data.videoArchiveName + " already exists. Unable to rename " + oldData.videoArchiveName));
        } else {
            VideoArchiveSetDAO videoArchiveSetDAO = toolBelt.getAnnotationDAOFactory().newVideoArchiveSetDAO(dao.getEntityManager());
            VideoArchive videoArchive = dao.findByPrimaryKey(this.primaryKey);
            if (videoArchive != null) {
                VideoArchiveSet videoArchiveSet = null;
                Collection videoArchiveSets = videoArchiveSetDAO.findAllByPlatformAndSequenceNumber(data.platformName, data.sequenceNumber);
                if (videoArchiveSets.size() > 0) {
                    videoArchiveSet = (VideoArchiveSet)videoArchiveSets.iterator().next();
                } else {
                    AnnotationFactory annotationFactory = toolBelt.getAnnotationFactory();
                    videoArchiveSet = annotationFactory.newVideoArchiveSet();
                    videoArchiveSet.setPlatformName(data.platformName);
                    dao.persist((Object)videoArchiveSet);
                    CameraDeployment cameraDeployment = annotationFactory.newCameraDeployment();
                    cameraDeployment.setSequenceNumber(Integer.valueOf(data.sequenceNumber));
                    videoArchiveSet.addCameraDeployment(cameraDeployment);
                    dao.persist((Object)cameraDeployment);
                }
                videoArchive.getVideoArchiveSet().removeVideoArchive(videoArchive);
                videoArchive.setName(data.videoArchiveName);
                videoArchiveSet.addVideoArchive(videoArchive);
                EventBus.publish((Object)new VideoArchiveSetChangedEvent((Object)null, videoArchiveSet));
            }
        }
        dao.endTransaction();
        dao.close();
    }

    @Override
    public String getDescription() {
        return "Rename VideoArchive from " + this.originalData.videoArchiveName + " to " + this.modifiedData.videoArchiveName;
    }

    private class DataBean {
        final String platformName;
        final int sequenceNumber;
        final String videoArchiveName;

        private DataBean(String platformName, int sequenceNumber, String videoArchiveName) {
            this.platformName = platformName;
            this.sequenceNumber = sequenceNumber;
            this.videoArchiveName = videoArchiveName;
        }
    }
}

