/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import org.bushe.swing.event.EventBus;
import vars.DAO;
import vars.annotation.Observation;
import vars.annotation.VideoArchive;
import vars.annotation.VideoFrame;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.ObservationsChangedEvent;

public class ChangeTimeCodeCmd
implements Command {
    private final Collection<DataBean> originalData;
    private final String timecode;

    public ChangeTimeCodeCmd(Collection<Observation> originalObservations, String timecode) {
        this.originalData = new ArrayList<DataBean>(Collections2.transform(originalObservations, (Function)new ObservationToDataBean()));
        this.timecode = timecode;
    }

    @Override
    public void apply(ToolBelt toolBelt) {
        this.doCommand(toolBelt, true);
    }

    private void doCommand(ToolBelt toolBelt, boolean isApply) {
        ArrayList<Observation> newObservations = new ArrayList<Observation>(this.originalData.size());
        DAO dao = toolBelt.getAnnotationDAOFactory().newDAO();
        dao.startTransaction();
        for (DataBean dataBean : this.originalData) {
            String tc;
            Observation observation = (Observation)dao.find((Object)dataBean.observation);
            VideoFrame sourceVideoFrame = observation.getVideoFrame();
            VideoArchive videoArchive = sourceVideoFrame.getVideoArchive();
            VideoFrame targetVideoFrame = videoArchive.findVideoFrameByTimeCode(tc = isApply ? this.timecode : dataBean.timecode);
            if (targetVideoFrame == null) {
                sourceVideoFrame.setTimecode(tc);
            } else {
                sourceVideoFrame.removeObservation(observation);
                targetVideoFrame.addObservation(observation);
            }
            newObservations.add(observation);
        }
        dao.endTransaction();
        dao.close();
        ObservationsChangedEvent updateEvent = new ObservationsChangedEvent((Object)null, (Collection<Observation>)newObservations);
        EventBus.publish((Object)updateEvent);
    }

    @Override
    public void unapply(ToolBelt toolBelt) {
        this.doCommand(toolBelt, false);
    }

    @Override
    public String getDescription() {
        return "Move " + this.originalData.size() + " Observations to timecode = " + this.timecode;
    }

    private class ObservationToDataBean
    implements Function<Observation, DataBean> {
        private ObservationToDataBean() {
        }

        public DataBean apply(Observation input) {
            return new DataBean(input.getVideoFrame().getTimecode(), input);
        }
    }

    private class DataBean {
        private final String timecode;
        private final Observation observation;

        private DataBean(String timecode, Observation observation) {
            this.timecode = timecode;
            this.observation = observation;
        }
    }
}

