/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import java.util.Collection;
import org.bushe.swing.event.EventBus;
import vars.VARSPersistenceException;
import vars.annotation.AnnotationFactory;
import vars.annotation.CameraDeployment;
import vars.annotation.FormatCodes;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.VideoArchiveSet;
import vars.annotation.VideoArchiveSetDAO;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.VideoArchiveSetChangedEvent;

public class ChangeSequenceNumberCmd
implements Command {
    private final int newSequenceNumber;
    private final int oldSequenceNumber;
    private final Long videoArchiveID;

    public ChangeSequenceNumberCmd(int newSequenceNumber, int oldSequenceNumber, Long videoArchiveID) {
        this.newSequenceNumber = newSequenceNumber;
        this.oldSequenceNumber = oldSequenceNumber;
        this.videoArchiveID = videoArchiveID;
    }

    @Override
    public void apply(ToolBelt toolBelt) {
        this.doChange(toolBelt, true);
    }

    @Override
    public void unapply(ToolBelt toolBelt) {
        this.doChange(toolBelt, false);
    }

    private void doChange(ToolBelt toolBelt, boolean isApply) {
        int newNumber = isApply ? this.newSequenceNumber : this.oldSequenceNumber;
        int oldNumber = isApply ? this.oldSequenceNumber : this.newSequenceNumber;
        VideoArchiveDAO dao = toolBelt.getAnnotationDAOFactory().newVideoArchiveDAO();
        VideoArchiveSetDAO vasDao = toolBelt.getAnnotationDAOFactory().newVideoArchiveSetDAO(dao.getEntityManager());
        dao.startTransaction();
        VideoArchive va = dao.findByPrimaryKey((Object)this.videoArchiveID);
        VideoArchiveSet videoArchiveSet = null;
        if (va != null) {
            String platformName = va.getVideoArchiveSet().getPlatformName();
            Collection vasList = vasDao.findAllByPlatformAndSequenceNumber(platformName, newNumber);
            if (vasList.isEmpty()) {
                AnnotationFactory factory = toolBelt.getAnnotationFactory();
                videoArchiveSet = factory.newVideoArchiveSet();
                videoArchiveSet.setPlatformName(platformName);
                videoArchiveSet.setFormatCode(FormatCodes.UNKNOWN.getCode());
                vasDao.persist((Object)videoArchiveSet);
                CameraDeployment cameraDeployment = factory.newCameraDeployment();
                cameraDeployment.setSequenceNumber(Integer.valueOf(newNumber));
                videoArchiveSet.addCameraDeployment(cameraDeployment);
                dao.persist((Object)cameraDeployment);
                va.getVideoArchiveSet().removeVideoArchive(va);
                videoArchiveSet.addVideoArchive(va);
            } else if (vasList.size() == 1) {
                videoArchiveSet = (VideoArchiveSet)vasList.iterator().next();
                va.getVideoArchiveSet().removeVideoArchive(va);
                videoArchiveSet.addVideoArchive(va);
            } else {
                throw new VARSPersistenceException("There's a problem!! More than one VideoArchiveSet with platform = " + platformName + " and sequenceNumber = " + newNumber + " exists in the database");
            }
        }
        dao.commit();
        dao.endTransaction();
        dao.close();
        if (videoArchiveSet != null) {
            EventBus.publish((Object)new VideoArchiveSetChangedEvent((Object)null, videoArchiveSet));
        }
    }

    @Override
    public String getDescription() {
        return "Change SequenceNumber of VideoArchive with id = " + this.videoArchiveID + " from " + this.oldSequenceNumber + " to " + this.newSequenceNumber;
    }
}

