/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import org.bushe.swing.event.EventBus;
import vars.annotation.ImmutablePhysicalData;
import vars.annotation.PhysicalData;
import vars.annotation.PhysicalDataDAO;
import vars.annotation.VideoFrame;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.VideoFramesChangedEvent;

public class ChangePhysicalDataCmd
implements Command {
    private final PhysicalData oldPhysicalData;
    private final PhysicalData newPhysicalData;

    public ChangePhysicalDataCmd(PhysicalData oldPhysicalData, PhysicalData newPhysicalData) {
        Preconditions.checkNotNull((Object)oldPhysicalData);
        Preconditions.checkNotNull((Object)newPhysicalData);
        this.oldPhysicalData = new ImmutablePhysicalData(oldPhysicalData);
        this.newPhysicalData = new ImmutablePhysicalData(newPhysicalData);
    }

    @Override
    public void apply(ToolBelt toolBelt) {
        this.doCommand(toolBelt, true);
    }

    @Override
    public void unapply(ToolBelt toolBelt) {
        this.doCommand(toolBelt, false);
    }

    private void doCommand(ToolBelt toolBelt, boolean isApply) {
        PhysicalData data = isApply ? this.newPhysicalData : this.oldPhysicalData;
        PhysicalDataDAO dao = toolBelt.getAnnotationDAOFactory().newPhysicalDataDAO();
        dao.startTransaction();
        PhysicalData pd = dao.findByPrimaryKey(this.oldPhysicalData.getPrimaryKey());
        VideoFramesChangedEvent event = null;
        if (pd != null) {
            pd.setAltitude(data.getAltitude());
            pd.setDepth(data.getDepth());
            pd.setLatitude(data.getLatitude());
            pd.setLight(data.getLight());
            pd.setLongitude(data.getLongitude());
            pd.setLogDate(data.getLogDate());
            pd.setOxygen(data.getOxygen());
            pd.setSalinity(data.getSalinity());
            pd.setTemperature(data.getTemperature());
            dao.commit();
            event = new VideoFramesChangedEvent((Object)null, (Collection<VideoFrame>)Collections.singletonList(pd.getVideoFrame()));
        }
        dao.endTransaction();
        dao.close();
        if (event != null) {
            EventBus.publish(event);
        }
    }

    @Override
    public String getDescription() {
        return null;
    }
}

