/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.bushe.swing.event.EventBus;
import vars.annotation.CameraData;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.VideoFrame;
import vars.annotation.VideoFrameDAO;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.VideoFramesChangedEvent;

public class ChangeCameraDirectionsCmd
implements Command {
    private final Collection<DataBean> originalData = new ArrayList<DataBean>();
    private final String cameraDirection;

    public ChangeCameraDirectionsCmd(String cameraDirection, Collection<VideoFrame> videoFrames) {
        this.cameraDirection = cameraDirection;
        for (VideoFrame videoFrame : videoFrames) {
            this.originalData.add(new DataBean(videoFrame.getPrimaryKey(), videoFrame.getCameraData().getDirection()));
        }
    }

    @Override
    public void apply(ToolBelt toolBelt) {
        this.doCommand(toolBelt, true);
    }

    private void doCommand(ToolBelt toolBelt, boolean isApply) {
        ArrayList<VideoFrame> modifiedVideoFrames = new ArrayList<VideoFrame>(this.originalData.size());
        VideoArchiveDAO dao = toolBelt.getAnnotationDAOFactory().newVideoArchiveDAO();
        VideoFrameDAO videoFrameDao = toolBelt.getAnnotationDAOFactory().newVideoFrameDAO(dao.getEntityManager());
        dao.startTransaction();
        for (DataBean bean : this.originalData) {
            VideoFrame videoFrame = videoFrameDao.findByPrimaryKey(bean.videoFramePrimaryKey);
            CameraData cameraData = videoFrame.getCameraData();
            if (isApply) {
                cameraData.setDirection(this.cameraDirection);
            } else {
                cameraData.setDirection(bean.originalDirection);
            }
            if (!dao.isPersistent((Object)cameraData)) {
                dao.persist((Object)cameraData);
            }
            modifiedVideoFrames.add(videoFrame);
        }
        dao.endTransaction();
        dao.close();
        EventBus.publish((Object)new VideoFramesChangedEvent((Object)null, (Collection<VideoFrame>)modifiedVideoFrames));
    }

    @Override
    public String getDescription() {
        return "Set camera direction of " + this.originalData.size() + " VideoFrames to " + this.cameraDirection;
    }

    @Override
    public void unapply(ToolBelt toolBelt) {
        this.doCommand(toolBelt, false);
    }

    private class DataBean {
        String originalDirection;
        Object videoFramePrimaryKey;

        private DataBean(Object videoFramePrimaryKey, String originalDirection) {
            this.videoFramePrimaryKey = videoFramePrimaryKey;
            this.originalDirection = originalDirection;
        }
    }
}

