/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import org.bushe.swing.event.EventBus;
import vars.annotation.CameraData;
import vars.annotation.CameraDataDAO;
import vars.annotation.VideoFrame;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.VideoFramesChangedEvent;

public class ChangeCameraDataCmd
implements Command {
    private final CameraData oldCameraData;
    private final CameraData newCameraData;

    public ChangeCameraDataCmd(CameraData oldCameraData, CameraData newCameraData) {
        Preconditions.checkNotNull((Object)newCameraData);
        Preconditions.checkNotNull((Object)oldCameraData);
        this.newCameraData = newCameraData;
        this.oldCameraData = oldCameraData;
    }

    @Override
    public void apply(ToolBelt toolBelt) {
        this.doCommand(toolBelt, true);
    }

    @Override
    public void unapply(ToolBelt toolBelt) {
        this.doCommand(toolBelt, false);
    }

    @Override
    public String getDescription() {
        return null;
    }

    private void doCommand(ToolBelt toolBelt, boolean isApply) {
        CameraData data = isApply ? this.newCameraData : this.oldCameraData;
        CameraDataDAO dao = toolBelt.getAnnotationDAOFactory().newCameraDataDAO();
        dao.startTransaction();
        CameraData cd = dao.findByPrimaryKey(this.oldCameraData.getPrimaryKey());
        VideoFramesChangedEvent event = null;
        if (cd != null) {
            cd.setDirection(data.getDirection());
            cd.setFieldWidth(data.getFieldWidth());
            cd.setFocus(data.getFocus());
            cd.setHeading(data.getHeading());
            cd.setImageReference(data.getImageReference());
            cd.setIris(data.getIris());
            cd.setLogDate(data.getLogDate());
            cd.setName(data.getName());
            cd.setPitch(data.getPitch());
            cd.setRoll(data.getRoll());
            cd.setViewHeight(data.getViewHeight());
            cd.setViewUnits(data.getViewUnits());
            cd.setViewWidth(data.getViewWidth());
            cd.setX(data.getX());
            cd.setXYUnits(data.getXYUnits());
            cd.setY(data.getY());
            cd.setZ(data.getZ());
            cd.setZoom(data.getZoom());
            cd.setZUnits(data.getZUnits());
            dao.commit();
            event = new VideoFramesChangedEvent((Object)null, (Collection<VideoFrame>)Collections.singletonList(cd.getVideoFrame()));
        }
        dao.endTransaction();
        dao.close();
        if (event != null) {
            EventBus.publish(event);
        }
    }
}

