/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import com.google.common.collect.ImmutableList;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Date;
import org.bushe.swing.event.EventBus;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.AnnotationFactory;
import vars.annotation.Observation;
import vars.annotation.ObservationDAO;
import vars.annotation.VideoArchive;
import vars.annotation.VideoFrame;
import vars.annotation.VideoFrameDAO;
import vars.annotation.jpa.ObservationImpl;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.ObservationsAddedEvent;
import vars.annotation.ui.eventbus.ObservationsRemovedEvent;
import vars.annotation.ui.eventbus.ObservationsSelectedEvent;

public class AddObservationToVideoFrameCmd
implements Command {
    private String conceptName;
    private final String user;
    private Object newPrimaryKey;
    private final Point2D point;
    private boolean selectAddedObservation = true;
    private VideoFrame videoFrameDetached;

    public AddObservationToVideoFrameCmd(String conceptName, VideoFrame videoFrame, String user, Point2D point, boolean selectAddedObservation) {
        this.conceptName = conceptName;
        this.user = user == null ? "default" : user;
        this.point = point;
        this.selectAddedObservation = selectAddedObservation;
        this.videoFrameDetached = videoFrame;
    }

    @Override
    public void apply(ToolBelt toolBelt) {
        AnnotationDAOFactory daoFactory = toolBelt.getAnnotationDAOFactory();
        AnnotationFactory factory = toolBelt.getAnnotationFactory();
        VideoFrameDAO videoFrameDAO = daoFactory.newVideoFrameDAO();
        videoFrameDAO.startTransaction();
        VideoFrame videoFrame = (VideoFrame)videoFrameDAO.find((Object)this.videoFrameDetached);
        Observation newObservation = null;
        if (this.conceptName != null && videoFrame != null) {
            String validatedConceptName = toolBelt.getPersistenceController().getValidatedConceptName(this.conceptName);
            newObservation = factory.newObservation();
            newObservation.setConceptName(validatedConceptName);
            newObservation.setObserver(this.user);
            newObservation.setObservationDate(new Date());
            if (this.point != null) {
                newObservation.setX(Double.valueOf(this.point.getX()));
                newObservation.setY(Double.valueOf(this.point.getY()));
            }
            videoFrame.addObservation(newObservation);
        }
        videoFrameDAO.endTransaction();
        videoFrameDAO.getEntityManager().clear();
        videoFrameDAO.close();
        if (newObservation != null) {
            this.newPrimaryKey = newObservation.getPrimaryKey();
            EventBus.publish((Object)new ObservationsAddedEvent((Object)null, newObservation));
            if (this.selectAddedObservation) {
                EventBus.publish((Object)new ObservationsSelectedEvent((Object)this, (Collection<Observation>)ImmutableList.of((Object)newObservation)));
            }
        }
    }

    @Override
    public void unapply(ToolBelt toolBelt) {
        if (this.newPrimaryKey != null) {
            AnnotationDAOFactory daoFactory = toolBelt.getAnnotationDAOFactory();
            ObservationDAO dao = daoFactory.newObservationDAO();
            VideoFrameDAO videoFrameDAO = daoFactory.newVideoFrameDAO(dao.getEntityManager());
            dao.startTransaction();
            Observation observation = dao.findByPrimaryKey(this.newPrimaryKey);
            ObservationImpl fakeObservation = null;
            if (observation != null) {
                ObservationImpl tmp = (ObservationImpl)toolBelt.getAnnotationFactory().newObservation();
                tmp.setId((Long)observation.getPrimaryKey());
                fakeObservation = tmp;
                VideoFrame videoFrame = observation.getVideoFrame();
                videoFrame.removeObservation(observation);
                dao.remove((Object)observation);
                if (videoFrame.getObservations().size() == 0) {
                    VideoArchive videoArchive = videoFrame.getVideoArchive();
                    videoArchive.removeVideoFrame(videoFrame);
                    videoFrameDAO.remove((Object)videoFrame);
                }
            }
            dao.endTransaction();
            dao.close();
            if (fakeObservation != null) {
                EventBus.publish((Object)new ObservationsRemovedEvent((Object)null, (Collection<Observation>)ImmutableList.of(fakeObservation)));
            }
        }
    }

    @Override
    public String getDescription() {
        return "Add new Observation (" + this.conceptName + ") to " + this.videoFrameDetached;
    }
}

