/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import com.google.common.collect.ImmutableList;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Date;
import org.bushe.swing.event.EventBus;
import org.mbari.movie.Timecode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.AnnotationFactory;
import vars.annotation.AnnotationPersistenceService;
import vars.annotation.CameraData;
import vars.annotation.Observation;
import vars.annotation.ObservationDAO;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.VideoFrame;
import vars.annotation.VideoFrameDAO;
import vars.annotation.jpa.ObservationImpl;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.ObservationsAddedEvent;
import vars.annotation.ui.eventbus.ObservationsRemovedEvent;
import vars.annotation.ui.eventbus.ObservationsSelectedEvent;

public class AddObservationCmd
implements Command {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private String conceptName;
    private final String timecode;
    private final Date recordedDate;
    private final String videoArchiveName;
    private final String user;
    private final String cameraDirection;
    private Object newPrimaryKey;
    private final Point2D point;
    private final String imageReference;
    private boolean selectAddedObservation = true;

    public AddObservationCmd(String conceptName, String timecode, Date recordedDate, String videoArchiveName, String user, String cameraDirection) {
        this(conceptName, timecode, recordedDate, videoArchiveName, user, cameraDirection, null, null, false);
    }

    public AddObservationCmd(String conceptName, String timecode, Date recordedDate, String videoArchiveName, String user, String cameraDirection, boolean selectAddedObservation) {
        this(conceptName, timecode, recordedDate, videoArchiveName, user, cameraDirection, null, null, selectAddedObservation);
    }

    public AddObservationCmd(String conceptName, String timecode, Date recordedDate, String videoArchiveName, String user, String cameraDirection, Point2D point) {
        this(conceptName, timecode, recordedDate, videoArchiveName, user, cameraDirection, point, null, false);
    }

    public AddObservationCmd(String conceptName, String timecode, Date recordedDate, String videoArchiveName, String user, String cameraDirection, Point2D point, boolean selectAddedObservation) {
        this(conceptName, timecode, recordedDate, videoArchiveName, user, cameraDirection, point, null, selectAddedObservation);
    }

    public AddObservationCmd(String conceptName, String timecode, Date recordedDate, String videoArchiveName, String user, String cameraDirection, Point2D point, String imageReference) {
        this(conceptName, timecode, recordedDate, videoArchiveName, user, cameraDirection, point, imageReference, false);
    }

    public AddObservationCmd(String conceptName, String timecode, Date recordedDate, String videoArchiveName, String user, String cameraDirection, Point2D point, String imageReference, boolean selectAddedObservation) {
        this.conceptName = conceptName;
        this.timecode = timecode;
        this.recordedDate = recordedDate;
        this.videoArchiveName = videoArchiveName;
        this.user = user == null ? "default" : user;
        this.cameraDirection = cameraDirection;
        this.point = point;
        this.imageReference = imageReference;
        this.selectAddedObservation = selectAddedObservation;
    }

    private double elapsedTime(Long start) {
        return (double)(System.nanoTime() - start) / 1.0E9;
    }

    @Override
    public void apply(ToolBelt toolBelt) {
        long tic = System.nanoTime();
        AnnotationPersistenceService annotationPersistenceService = toolBelt.getAnnotationPersistenceService();
        AnnotationDAOFactory daoFactory = toolBelt.getAnnotationDAOFactory();
        AnnotationFactory factory = toolBelt.getAnnotationFactory();
        VideoFrameDAO videoFrameDAO = daoFactory.newVideoFrameDAO();
        VideoArchiveDAO videoArchiveDAO = daoFactory.newVideoArchiveDAO(videoFrameDAO.getEntityManager());
        videoArchiveDAO.startTransaction();
        VideoArchive videoArchive = videoArchiveDAO.findByName(this.videoArchiveName);
        Observation newObservation = null;
        if (videoArchive != null && this.conceptName != null && this.timecode != null) {
            new Timecode(this.timecode);
            this.log.debug(this.elapsedTime(tic) + "s :Lookup existing videoframe");
            Long id = annotationPersistenceService.findTimeCodeByVideoArchiveName(this.timecode, this.videoArchiveName);
            VideoFrame videoFrame = null;
            if (id != null) {
                videoFrame = videoFrameDAO.findByPrimaryKey((Object)id);
            }
            this.log.debug(this.elapsedTime(tic) + "s :Find matching timecode");
            tic = System.nanoTime();
            if (videoFrame == null) {
                videoFrame = factory.newVideoFrame();
                videoFrame.setRecordedDate(this.recordedDate);
                videoFrame.setTimecode(this.timecode);
                CameraData cameraData = videoFrame.getCameraData();
                cameraData.setDirection(this.cameraDirection);
                this.log.debug(this.elapsedTime(tic) + "s :Build new videoframe");
                tic = System.nanoTime();
                videoArchive.addVideoFrame(videoFrame);
            }
            if (this.imageReference != null) {
                videoFrame.getCameraData().setImageReference(this.imageReference);
            }
            this.log.debug(this.elapsedTime(tic) + "s :Built Videoframe");
            tic = System.nanoTime();
            String validatedConceptName = toolBelt.getPersistenceController().getValidatedConceptName(this.conceptName);
            newObservation = factory.newObservation();
            newObservation.setConceptName(validatedConceptName);
            newObservation.setObserver(this.user);
            newObservation.setObservationDate(new Date());
            if (this.point != null) {
                newObservation.setX(Double.valueOf(this.point.getX()));
                newObservation.setY(Double.valueOf(this.point.getY()));
            }
            videoFrame.addObservation(newObservation);
            this.log.debug(this.elapsedTime(tic) + "s :Built Observation");
            tic = System.nanoTime();
        }
        videoArchiveDAO.endTransaction();
        videoArchiveDAO.getEntityManager().clear();
        videoArchiveDAO.close();
        this.log.debug(this.elapsedTime(tic) + "s :End Transaction");
        tic = System.nanoTime();
        if (newObservation != null) {
            this.newPrimaryKey = newObservation.getPrimaryKey();
        }
        EventBus.publish((Object)new ObservationsAddedEvent((Object)null, newObservation));
        this.log.debug(this.elapsedTime(tic) + "s :Publish ObservationsAddedEvent");
        tic = System.nanoTime();
        if (this.selectAddedObservation) {
            EventBus.publish((Object)new ObservationsSelectedEvent((Object)this, (Collection<Observation>)ImmutableList.of(newObservation)));
            this.log.debug(this.elapsedTime(tic) + "s :Publish ObservationsSelectedEvent");
            tic = System.nanoTime();
        }
    }

    @Override
    public void unapply(ToolBelt toolBelt) {
        if (this.newPrimaryKey != null) {
            AnnotationDAOFactory daoFactory = toolBelt.getAnnotationDAOFactory();
            ObservationDAO dao = daoFactory.newObservationDAO();
            VideoFrameDAO videoFrameDAO = daoFactory.newVideoFrameDAO(dao.getEntityManager());
            dao.startTransaction();
            Observation observation = dao.findByPrimaryKey(this.newPrimaryKey);
            ObservationImpl fakeObservation = null;
            if (observation != null) {
                ObservationImpl tmp = (ObservationImpl)toolBelt.getAnnotationFactory().newObservation();
                tmp.setId((Long)observation.getPrimaryKey());
                fakeObservation = tmp;
                VideoFrame videoFrame = observation.getVideoFrame();
                videoFrame.removeObservation(observation);
                dao.remove((Object)observation);
                if (videoFrame.getObservations().size() == 0) {
                    VideoArchive videoArchive = videoFrame.getVideoArchive();
                    videoArchive.removeVideoFrame(videoFrame);
                    videoFrameDAO.remove((Object)videoFrame);
                }
            }
            dao.endTransaction();
            dao.close();
            if (fakeObservation != null) {
                EventBus.publish((Object)new ObservationsRemovedEvent((Object)null, (Collection<Observation>)ImmutableList.of(fakeObservation)));
            }
        }
    }

    @Override
    public String getDescription() {
        return "Add new Observation (" + this.conceptName + ") to " + this.timecode + " (" + this.recordedDate + ")";
    }
}

