/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import org.bushe.swing.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ILink;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.AnnotationFactory;
import vars.annotation.Association;
import vars.annotation.AssociationDAO;
import vars.annotation.Observation;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.eventbus.ObservationsChangedEvent;

public class AddAssociationCmd
implements Command {
    protected final ILink associationTemplate;
    protected final Collection<Observation> originalObservations;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public AddAssociationCmd(ILink associationTemplate, Collection<Observation> originalObservations) {
        this.associationTemplate = associationTemplate;
        this.originalObservations = new ArrayList<Observation>(originalObservations);
    }

    @Override
    public void apply(ToolBelt toolBelt) {
        this.doCommand(toolBelt, true);
    }

    @Override
    public void unapply(ToolBelt toolBelt) {
        this.doCommand(toolBelt, false);
    }

    protected void doCommand(ToolBelt toolBelt, boolean isApply) {
        ArrayList<Observation> newObservations = new ArrayList<Observation>();
        AnnotationDAOFactory annotationDAOFactory = toolBelt.getAnnotationDAOFactory();
        AnnotationFactory annotationFactory = toolBelt.getAnnotationFactory();
        AssociationDAO dao = annotationDAOFactory.newAssociationDAO();
        dao.startTransaction();
        for (Observation observation : this.originalObservations) {
            try {
                observation = (Observation)dao.find((Object)observation);
            }
            catch (Exception e) {
                this.log.warn("Failed to lookup {}", (Object)observation);
            }
            if (observation == null) continue;
            newObservations.add(observation);
            Association ass = annotationFactory.newAssociation(this.associationTemplate);
            String validatedToConcept = toolBelt.getPersistenceController().getValidatedConceptName(ass.getToConcept());
            ass.setToConcept(validatedToConcept);
            if (isApply) {
                observation.addAssociation(ass);
                dao.persist((Object)ass);
                continue;
            }
            Collection matchingAssociation = Collections2.filter((Collection)observation.getAssociations(), (Predicate)new IsMatchingAnnotation((ILink)ass));
            if (matchingAssociation.size() != 1) continue;
            Association match = (Association)matchingAssociation.iterator().next();
            observation.removeAssociation(match);
            dao.remove((Object)match);
        }
        dao.endTransaction();
        dao.close();
        ObservationsChangedEvent updateEvent = new ObservationsChangedEvent((Object)null, (Collection<Observation>)newObservations);
        EventBus.publish((Object)updateEvent);
    }

    @Override
    public String getDescription() {
        return "Add Association (" + this.associationTemplate + ") to " + this.originalObservations.size() + " observations";
    }

    private class IsMatchingAnnotation
    implements Predicate<Association> {
        private final ILink link;

        private IsMatchingAnnotation(ILink link) {
            this.link = link;
        }

        public boolean apply(Association input) {
            return input.getLinkName().equals(this.link.getLinkName()) && input.getLinkValue().equals(this.link.getLinkValue()) && input.getToConcept().equals(this.link.getToConcept());
        }
    }
}

