/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.commandqueue;

import java.util.Deque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.ClearCommandQueueEvent;
import vars.annotation.ui.commandqueue.Command;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.RedoEvent;
import vars.annotation.ui.commandqueue.UndoEvent;

public class CommandQueue {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int maxUndos = 25;
    private final BlockingQueue<CommandEvent> pendingQueue = new LinkedBlockingQueue<CommandEvent>();
    private final Deque<CommandEvent> undos = new LinkedBlockingDeque<CommandEvent>(25);
    private final Deque<CommandEvent> redos = new LinkedBlockingDeque<CommandEvent>(25);
    private final Thread thread;
    private final ToolBelt toolBelt;
    private final Runnable runnable = new Runnable(){
        private volatile boolean isRunning = true;

        @Override
        public void run() {
            while (this.isRunning) {
                CommandEvent commandEvent = null;
                try {
                    commandEvent = (CommandEvent)CommandQueue.this.pendingQueue.poll(3600L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                }
                if (commandEvent == null) continue;
                Command command = commandEvent.getCommand();
                try {
                    CommandQueue.this.log.debug("Executing Command: " + (Object)((Object)commandEvent.getDoOrUndo()) + " - " + command.getDescription());
                    Deque inverseCommandList = null;
                    switch (commandEvent.getDoOrUndo()) {
                        case DO: {
                            command.apply(CommandQueue.this.toolBelt);
                            inverseCommandList = CommandQueue.this.undos;
                            break;
                        }
                        case UNDO: {
                            command.unapply(CommandQueue.this.toolBelt);
                            inverseCommandList = CommandQueue.this.redos;
                        }
                    }
                    int size = inverseCommandList.size();
                    if (size >= 25) {
                        inverseCommandList.pollFirst();
                    }
                    inverseCommandList.offerLast(commandEvent);
                }
                catch (Exception e) {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                }
            }
        }

        void kill() {
            this.isRunning = false;
        }
    };

    public CommandQueue(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        AnnotationProcessor.process((Object)this);
        this.thread = new Thread(this.runnable, this.getClass().getName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @EventSubscriber(eventClass=ClearCommandQueueEvent.class)
    public void clear(ClearCommandQueueEvent event) {
        this.undos.clear();
        this.redos.clear();
    }

    @EventSubscriber(eventClass=CommandEvent.class)
    public void queueCommand(CommandEvent event) {
        this.pendingQueue.offer(event);
    }

    @EventSubscriber(eventClass=RedoEvent.class)
    public void redo(RedoEvent event) {
        if (this.redos.size() > 0) {
            CommandEvent commandEvent = this.redos.removeLast();
            CommandEvent newCommandEvent = new CommandEvent(commandEvent.getCommand(), CommandEvent.DoOrUndo.DO);
            this.queueCommand(newCommandEvent);
        }
    }

    @EventSubscriber(eventClass=UndoEvent.class)
    public void undo(UndoEvent event) {
        if (this.undos.size() > 0) {
            CommandEvent commandEvent = this.undos.removeLast();
            CommandEvent newCommandEvent = new CommandEvent(commandEvent.getCommand(), CommandEvent.DoOrUndo.UNDO);
            this.queueCommand(newCommandEvent);
        }
    }
}

