/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.cbpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.CompoundBorder;
import org.bushe.swing.event.EventBus;
import org.mbari.swing.IPopup;
import org.mbari.util.Dispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.CacheClearedEvent;
import vars.CacheClearedListener;
import vars.UserAccount;
import vars.annotation.VideoArchive;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.actions.NewObservationUsingConceptNameAction;
import vars.avplayer.VideoController;
import vars.knowledgebase.KnowledgebasePersistenceService;
import vars.shared.ui.FancyButton;

public class NewObservationUsingConceptNameButton
extends FancyButton
implements IPopup,
Transferable,
DragSourceListener,
DragGestureListener {
    public static final String DISPATCHER_KEY_DRAG_LOCK = "NewObservationUsingConceptNameButton.DRAG_LOCK";
    public static final DataFlavor BUTTON_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "NewObservationUsingConceptNameButton");
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DataFlavor[] _flavors = new DataFlavor[]{BUTTON_FLAVOR};
    private final String conceptName;
    private boolean hasPerson;
    private boolean hasVcr;
    private boolean hasVideoArchive;
    private boolean isInitialized;
    private JPopupMenu popupMenu;
    private final ToolBelt toolbelt;

    public NewObservationUsingConceptNameButton(String conceptName, ToolBelt toolbelt) {
        this.toolbelt = toolbelt;
        this.conceptName = conceptName;
        this.intialize();
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer((Component)((Object)this), 3, this);
        this.setAction((Action)((Object)new NewObservationUsingConceptNameAction(toolbelt, conceptName)));
        this.setText(conceptName);
        this.setToolTipText(conceptName);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    NewObservationUsingConceptNameButton.this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        StateLookup.videoArchiveProperty().addListener((obs, oldVal, newVal) -> {
            this.hasVideoArchive = newVal != null;
            this.checkEnable();
        });
        StateLookup.userAccountProperty().addListener((obs, oldVal, newVal) -> {
            this.hasPerson = newVal != null;
            this.checkEnable();
        });
        StateLookup.videoControllerProperty().addListener((obs, oldVal, newVal) -> {
            this.hasVcr = newVal != null;
            this.checkEnable();
        });
        toolbelt.getPersistenceCache().addCacheClearedListener(new CacheClearedListener(){

            public void afterClear(CacheClearedEvent evt) {
                NewObservationUsingConceptNameButton.this.checkEnable();
            }

            public void beforeClear(CacheClearedEvent evt) {
                NewObservationUsingConceptNameButton.this.setEnabled(false);
            }
        });
        this.checkEnable();
    }

    private void checkEnable() {
        boolean enable = false;
        if (this.hasVcr && this.hasPerson && this.hasVideoArchive) {
            try {
                KnowledgebasePersistenceService kbPersistenceService = this.toolbelt.getKnowledgebasePersistenceService();
                enable = kbPersistenceService.doesConceptNameExist(this.conceptName);
            }
            catch (Exception e) {
                this.log.error("Failed to lookup '" + this.conceptName + "' from the database", (Throwable)e);
            }
        }
        this.setEnabled(enable);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGesture) {
        Dispatcher dispatcher = Dispatcher.getDispatcher((Object)DISPATCHER_KEY_DRAG_LOCK);
        Boolean isDragLocked = (Boolean)dispatcher.getValueObject();
        if (isDragLocked == null || Boolean.FALSE.equals(isDragLocked)) {
            Point ptDragOrigin = dragGesture.getDragOrigin();
            Component component = this.getComponentAt(ptDragOrigin);
            if (!(component instanceof NewObservationUsingConceptNameButton)) {
                return;
            }
            NewObservationUsingConceptNameButton dragButton = (NewObservationUsingConceptNameButton)((Object)component);
            dragGesture.startDrag(DragSource.DefaultMoveDrop, dragButton, this);
        }
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public String getConceptName() {
        return this.conceptName;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            JMenuItem find = new JMenuItem("Find in Knowledgebase tree");
            find.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    EventBus.publish((String)"vars-annotation.ui.StateLookup-SelectedConcept", (Object)NewObservationUsingConceptNameButton.this.getConceptName());
                }
            });
            this.popupMenu.add(find);
        }
        return this.popupMenu;
    }

    @Override
    public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.isMimeTypeEqual(BUTTON_FLAVOR.getMimeType())) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this._flavors;
    }

    void intialize() {
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.ORANGE, Color.GRAY), BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.setBorder(border);
        if (!this.isInitialized) {
            VideoArchive videoArchive = StateLookup.getVideoArchive();
            this.hasVideoArchive = videoArchive != null;
            UserAccount userAccount = StateLookup.getUserAccount();
            this.hasPerson = userAccount != null;
            VideoController videoController = StateLookup.getVideoController();
            this.hasVcr = videoController != null;
        }
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return Arrays.asList(this._flavors).contains(flavor);
    }
}

