/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.cbpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.util.Dispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.UserAccount;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.cbpanel.ConceptButtonDropPanel;
import vars.annotation.ui.cbpanel.ConceptButtonOverviewPanel;
import vars.annotation.ui.dialogs.NewConceptButtonTabDialog;
import vars.jpa.VarsUserPreferences;
import vars.shared.ui.FancyButton;

public class ConceptButtonPanel
extends JPanel {
    private JPanel buttonPanel = null;
    private JButton lockButton = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String PREF_CP_NODE = "vars.annotation.ui.cbpanel.ConceptButtonPanel";
    public static final String PREFKEY_TABNAME = "tabName";
    public static final String TAB_PREFIX = "tab";
    private final JButton moveTabButton = null;
    private JButton newTabButton = null;
    private ConceptButtonOverviewPanel overviewPanel = null;
    private JButton removeTabButton = null;
    private JButton renameTabButton = null;
    private boolean locked = true;
    private JButton showOverviewButton = null;
    private Preferences userPreferences = null;
    private boolean showOverview = false;
    private final ImageIcon hideIndexIcon;
    private final ImageIcon lockedIcon;
    private ActionAdapter newTabAction;
    private ActionAdapter removeTabAction;
    private ActionAdapter renameTabAction;
    private final ImageIcon showIndexIcon;
    private JTabbedPane tabbedPane;
    private final ToolBelt toolBelt;
    private final ImageIcon unlockedIcon;

    public ConceptButtonPanel(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        this.lockedIcon = new ImageIcon(this.getClass().getResource("/images/vars/annotation/lock-16.png"));
        this.unlockedIcon = new ImageIcon(this.getClass().getResource("/images/vars/annotation/lock_open-16.png"));
        this.showIndexIcon = new ImageIcon(this.getClass().getResource("/images/vars/annotation/16px/index_up.png"));
        this.hideIndexIcon = new ImageIcon(this.getClass().getResource("/images/vars/annotation/16px/index_down.png"));
        this.initialize();
    }

    public void changeUserPreferences() {
        this.userPreferences = StateLookup.getPreferences();
        if (this.userPreferences != null) {
            this.loadTabsFromPreferences();
        } else {
            this.getTabbedPane().removeAll();
            this.getOverviewPanel().removeAll();
        }
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
            this.buttonPanel.add(this.getNewTabButton());
            this.buttonPanel.add(this.getRenameTabButton());
            this.buttonPanel.add(this.getRemoveTabButton());
            this.buttonPanel.add(this.getLockButton());
            this.buttonPanel.add(this.getShowOverviewButton());
            this.buttonPanel.add(Box.createVerticalGlue());
        }
        return this.buttonPanel;
    }

    protected JButton getLockButton() {
        if (this.lockButton == null) {
            this.lockButton = new FancyButton();
            this.lockButton.setText("");
            this.lockButton.setToolTipText("Buttons on the tabs can not be reordered when locked");
            this.lockButton.setIcon(this.lockedIcon);
            final Dispatcher dispatcher = Dispatcher.getDispatcher((Object)"NewObservationUsingConceptNameButton.DRAG_LOCK");
            dispatcher.setValueObject((Object)this.locked);
            this.lockButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConceptButtonPanel.this.locked = !ConceptButtonPanel.this.locked;
                    Boolean isDragLocked = ConceptButtonPanel.this.locked;
                    dispatcher.setValueObject((Object)isDragLocked);
                }
            });
            dispatcher.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean locked = (Boolean)evt.getNewValue();
                    if (locked) {
                        ConceptButtonPanel.this.lockButton.setIcon(ConceptButtonPanel.this.lockedIcon);
                    } else {
                        ConceptButtonPanel.this.lockButton.setIcon(ConceptButtonPanel.this.unlockedIcon);
                    }
                }
            });
        }
        return this.lockButton;
    }

    protected JButton getMoveTabButton() {
        if (this.moveTabButton == null) {
            // empty if block
        }
        return this.moveTabButton;
    }

    protected ActionAdapter getNewTabAction() {
        if (this.newTabAction == null) {
            this.newTabAction = new NewTabAction();
            this.newTabAction.setEnabled(false);
        }
        return this.newTabAction;
    }

    protected JButton getNewTabButton() {
        if (this.newTabButton == null) {
            this.newTabButton = new FancyButton((Action)this.getNewTabAction());
            this.newTabButton.setText("");
            this.newTabButton.setToolTipText("Create New Tab");
            this.newTabButton.setMnemonic(0);
            this.newTabButton.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/add2-16.png")));
        }
        return this.newTabButton;
    }

    protected ConceptButtonOverviewPanel getOverviewPanel() {
        if (this.overviewPanel == null) {
            this.overviewPanel = new ConceptButtonOverviewPanel(this.toolBelt);
        }
        return this.overviewPanel;
    }

    protected ActionAdapter getRemoveTabAction() {
        if (this.removeTabAction == null) {
            this.removeTabAction = new RemoveTabAction();
            this.removeTabAction.setEnabled(false);
        }
        return this.removeTabAction;
    }

    protected JButton getRemoveTabButton() {
        if (this.removeTabButton == null) {
            this.removeTabButton = new FancyButton((Action)this.getRemoveTabAction());
            this.removeTabButton.setText("");
            this.removeTabButton.setToolTipText("Remove Tab");
            this.removeTabButton.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/delete2-16.png")));
        }
        return this.removeTabButton;
    }

    protected ActionAdapter getRenameTabAction() {
        if (this.renameTabAction == null) {
            this.renameTabAction = new ActionAdapter(){

                public void doAction() {
                }
            };
        }
        return this.renameTabAction;
    }

    protected JButton getRenameTabButton() {
        if (this.renameTabButton == null) {
            this.renameTabButton = new FancyButton((Action)this.getRenameTabAction());
            this.renameTabButton.setText("");
            this.renameTabButton.setToolTipText("Rename Tab");
            this.renameTabButton.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/replace2-16.png")));
            this.renameTabButton.setEnabled(false);
        }
        return this.renameTabButton;
    }

    protected JButton getShowOverviewButton() {
        if (this.showOverviewButton == null) {
            this.showOverviewButton = new FancyButton();
            this.showOverviewButton.setText("");
            this.showOverviewButton.setIcon(this.showIndexIcon);
            this.showOverviewButton.setToolTipText("Show overview tab");
            this.showOverviewButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConceptButtonPanel.this.showOverview = !ConceptButtonPanel.this.showOverview;
                    if (ConceptButtonPanel.this.showOverview) {
                        ConceptButtonOverviewPanel panel = ConceptButtonPanel.this.getOverviewPanel();
                        ConceptButtonPanel.this.showOverviewButton.setIcon(ConceptButtonPanel.this.hideIndexIcon);
                        panel.loadPreferences();
                        ConceptButtonPanel.this.getTabbedPane().add("  OVERVIEW  ", panel);
                        ConceptButtonPanel.this.showOverviewButton.setToolTipText("Hide overview tab");
                        ConceptButtonPanel.this.getTabbedPane().setSelectedComponent(panel);
                    } else {
                        ConceptButtonPanel.this.showOverviewButton.setIcon(ConceptButtonPanel.this.showIndexIcon);
                        ConceptButtonPanel.this.getTabbedPane().remove(ConceptButtonPanel.this.getOverviewPanel());
                        ConceptButtonPanel.this.showOverviewButton.setToolTipText("Show overview tab");
                    }
                }
            });
        }
        return this.showOverviewButton;
    }

    protected JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane(3);
        }
        return this.tabbedPane;
    }

    private void initialize() {
        this.setOpaque(true);
        this.setBackground(UIManager.getColor("control"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTabbedPane(), "Center");
        this.add((Component)this.getButtonPanel(), "East");
        StateLookup.userAccountProperty().addListener((obs, oldVal, newVal) -> {
            boolean enabled = newVal != null;
            this.getNewTabAction().setEnabled(enabled);
            this.getRenameTabAction().setEnabled(enabled);
            this.getRemoveTabAction().setEnabled(enabled);
        });
        StateLookup.preferencesProperty().addListener((obs, oldVal, newVal) -> this.changeUserPreferences());
    }

    private void loadTabsFromPreferences() {
        this.getTabbedPane().removeAll();
        Preferences cpPrefs = this.userPreferences.node(PREF_CP_NODE);
        if (cpPrefs != null) {
            String[] tabNames = null;
            try {
                tabNames = cpPrefs.childrenNames();
            }
            catch (BackingStoreException bse) {
                this.log.error("Problem loading user tabs.", (Throwable)bse);
            }
            for (int i = 0; i < tabNames.length; ++i) {
                Preferences tabPrefs = cpPrefs.node(tabNames[i]);
                String tabName = tabPrefs.get(PREFKEY_TABNAME, "dummy");
                ConceptButtonDropPanel panel = new ConceptButtonDropPanel(cpPrefs.node(tabNames[i]), this.toolBelt);
                this.getTabbedPane().add(tabName, panel);
            }
        }
        this.setVisible(true);
    }

    private class RenameTabAction
    extends ActionAdapter {
        private RenameTabAction() {
        }

        public void doAction() {
            UserAccount userAccount = StateLookup.getUserAccount();
            if (userAccount == null) {
                return;
            }
        }
    }

    private class RemoveTabAction
    extends ActionAdapter {
        private RemoveTabAction() {
        }

        public void doAction() {
            UserAccount userAccount = StateLookup.getUserAccount();
            if (userAccount != null) {
                int response = JOptionPane.showConfirmDialog(ConceptButtonPanel.this, "This action will remove the currently selected tab.  Are you sure?");
                switch (response) {
                    case 0: {
                        Preferences cpPrefs = ConceptButtonPanel.this.userPreferences.node(ConceptButtonPanel.PREF_CP_NODE);
                        int currentTabNumber = ConceptButtonPanel.this.getTabbedPane().getSelectedIndex();
                        try {
                            cpPrefs.node(ConceptButtonPanel.TAB_PREFIX + currentTabNumber).removeNode();
                        }
                        catch (BackingStoreException bse) {
                            ConceptButtonPanel.this.log.error("Problem removing a tab.", (Throwable)bse);
                        }
                        for (int i = currentTabNumber + 1; i < ConceptButtonPanel.this.getTabbedPane().getTabCount(); ++i) {
                            VarsUserPreferences.copyPrefs((Preferences)cpPrefs.node(ConceptButtonPanel.TAB_PREFIX + i), (Preferences)cpPrefs.node(ConceptButtonPanel.TAB_PREFIX + (i - 1)));
                            try {
                                cpPrefs.node(ConceptButtonPanel.TAB_PREFIX + i).removeNode();
                                continue;
                            }
                            catch (BackingStoreException bse) {
                                ConceptButtonPanel.this.log.error("Problem removing a tab from preferences.", (Throwable)bse);
                            }
                        }
                        ConceptButtonPanel.this.loadTabsFromPreferences();
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
            }
        }
    }

    private class NewTabAction
    extends ActionAdapter {
        private NewTabAction() {
        }

        public void doAction() {
            UserAccount userAccount = StateLookup.getUserAccount();
            if (userAccount == null) {
                JOptionPane.showMessageDialog(ConceptButtonPanel.this, "You must be logged in to create a new tab");
                return;
            }
            NewConceptButtonTabDialog newConceptButtonTabDialog = new NewConceptButtonTabDialog("Enter New Tab Name");
            String tabName = null;
            if (newConceptButtonTabDialog != null) {
                tabName = newConceptButtonTabDialog.getReturnValue();
            }
            if (tabName != null && ConceptButtonPanel.this.userPreferences != null && ConceptButtonPanel.this.userPreferences.node(ConceptButtonPanel.PREF_CP_NODE) != null) {
                Preferences cpPrefs = ConceptButtonPanel.this.userPreferences.node(ConceptButtonPanel.PREF_CP_NODE);
                String[] cpTabs = null;
                try {
                    cpTabs = cpPrefs.childrenNames();
                }
                catch (BackingStoreException bse) {
                    ConceptButtonPanel.this.log.error("Caught an Exception", (Throwable)bse);
                }
                boolean alreadyThere = false;
                for (int j = 0; j < cpTabs.length; ++j) {
                    Preferences tabPrefs = cpPrefs.node(ConceptButtonPanel.TAB_PREFIX + j);
                    if (tabPrefs.get(ConceptButtonPanel.PREFKEY_TABNAME, "").compareTo(tabName) != 0) continue;
                    alreadyThere = true;
                }
                if (!alreadyThere) {
                    Preferences newTabPrefs = cpPrefs.node(ConceptButtonPanel.TAB_PREFIX + cpTabs.length);
                    newTabPrefs.put(ConceptButtonPanel.PREFKEY_TABNAME, tabName);
                    ConceptButtonDropPanel dropPanel = new ConceptButtonDropPanel(newTabPrefs, ConceptButtonPanel.this.toolBelt);
                    ConceptButtonPanel.this.getTabbedPane().add(tabName, dropPanel);
                } else {
                    JOptionPane.showMessageDialog(ConceptButtonPanel.this, "A tab by that name already exists");
                }
            }
            newConceptButtonTabDialog.dispose();
        }
    }
}

