/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.cbpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.cbpanel.ConceptButtonDropPanelWithHighlights;

public class ConceptButtonOverviewPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(ConceptButtonOverviewPanel.class);
    private JScrollPane scrollPane = null;
    private JPanel overviewPanel = null;
    private final ToolBelt toolBelt;

    public ConceptButtonOverviewPanel(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        this.initialize();
        StateLookup.preferencesProperty().addListener((obs, oldVal, newVal) -> this.loadPreferences());
        this.loadPreferences();
    }

    void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getScrollPane(), "Center");
    }

    public void loadPreferences() {
        this.getOverviewPanel().removeAll();
        Preferences userPreferences = StateLookup.getPreferences();
        Preferences cpPreferences = userPreferences.node("vars.annotation.ui.cbpanel.ConceptButtonPanel");
        if (cpPreferences != null) {
            String[] tabNames = null;
            try {
                tabNames = cpPreferences.childrenNames();
            }
            catch (BackingStoreException bse) {
                log.error("Problem loading user tabs.", (Throwable)bse);
            }
            if (tabNames != null) {
                for (int i = 0; i < tabNames.length; ++i) {
                    String tabName = tabNames[i];
                    ConceptButtonDropPanelWithHighlights panel = new ConceptButtonDropPanelWithHighlights(cpPreferences.node(tabName), this.toolBelt);
                    panel.setBorder(BorderFactory.createTitledBorder(cpPreferences.node(tabName).get("tabName", "")));
                    this.getOverviewPanel().add(panel);
                }
            }
        }
    }

    protected JPanel getOverviewPanel() {
        if (this.overviewPanel == null) {
            this.overviewPanel = new JPanel();
            this.overviewPanel.setLayout(new FlowLayout(3));
        }
        return this.overviewPanel;
    }

    protected JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getOverviewPanel());
        }
        return this.scrollPane;
    }
}

