/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.cbpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.cbpanel.ConceptButtonDropPanel;

public class ConceptButtonDropPanelWithHighlights
extends ConceptButtonDropPanel {
    JButton lastButtonPressed;
    Color defaultBackgroundColor;
    Color defaultForegroundColor;
    Color highlightBackgroundColor = Color.LIGHT_GRAY;
    Color highLightForegroundColor = Color.RED.darker();
    final ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ConceptButtonDropPanelWithHighlights.this.defaultBackgroundColor == null || ConceptButtonDropPanelWithHighlights.this.defaultForegroundColor == null) {
                ConceptButtonDropPanelWithHighlights.this.resolveDefaultColors();
            }
            if (ConceptButtonDropPanelWithHighlights.this.lastButtonPressed != null) {
                ConceptButtonDropPanelWithHighlights.this.lastButtonPressed.setBackground(ConceptButtonDropPanelWithHighlights.this.defaultBackgroundColor);
                ConceptButtonDropPanelWithHighlights.this.lastButtonPressed.setForeground(ConceptButtonDropPanelWithHighlights.this.defaultForegroundColor);
            }
            ConceptButtonDropPanelWithHighlights.this.lastButtonPressed = (JButton)e.getSource();
            ConceptButtonDropPanelWithHighlights.this.lastButtonPressed.setForeground(ConceptButtonDropPanelWithHighlights.this.highLightForegroundColor);
            ConceptButtonDropPanelWithHighlights.this.lastButtonPressed.setBackground(ConceptButtonDropPanelWithHighlights.this.highlightBackgroundColor);
        }
    };

    public ConceptButtonDropPanelWithHighlights(Preferences tabPreferences, ToolBelt toolBelt) {
        super(tabPreferences, toolBelt);
        this.checkForActionListener();
    }

    @Override
    DropTargetListener getDTListener() {
        if (this.dtListener == null) {
            this.dtListener = new DTListener2();
        }
        return this.dtListener;
    }

    private void resolveDefaultColors() {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (!(component instanceof JButton)) continue;
            JButton button = (JButton)component;
            this.defaultBackgroundColor = button.getBackground();
            this.defaultForegroundColor = button.getForeground();
            break;
        }
    }

    private void checkForActionListener() {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (!(component instanceof JButton)) continue;
            JButton button = (JButton)component;
            ActionListener[] registeredListeners = button.getActionListeners();
            boolean foundIt = false;
            for (ActionListener listener : registeredListeners) {
                boolean bl = foundIt = listener == this.actionListener;
                if (foundIt) break;
            }
            if (foundIt) continue;
            button.addActionListener(this.actionListener);
        }
    }

    class DTListener2
    extends ConceptButtonDropPanel.DTListener {
        DTListener2() {
            super(ConceptButtonDropPanelWithHighlights.this);
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            super.drop(e);
            ConceptButtonDropPanelWithHighlights.this.checkForActionListener();
        }
    }
}

