/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.cbpanel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.layout.WrappingFlowLayout;
import org.mbari.swing.IPopup;
import org.mbari.swing.SwingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.cbpanel.NewObservationUsingConceptNameButton;
import vars.shared.ui.StringTransferable;

public class ConceptButtonDropPanel
extends JPanel {
    private static final String PREF_BUTTON_NAME = "name";
    private static final String PREF_BUTTON_ORDER = "order";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Preferences tabPreferences = null;
    private final int acceptableActions = 3;
    private DropTarget dropTarget;
    DropTargetListener dtListener;
    private final ToolBelt toolbelt;

    public ConceptButtonDropPanel(Preferences tabPreferences, ToolBelt toolbelt) {
        this.tabPreferences = tabPreferences;
        this.toolbelt = toolbelt;
        WrappingFlowLayout cbFlow = new WrappingFlowLayout(0);
        this.setLayout((LayoutManager)cbFlow);
        cbFlow.setHgap(5);
        this.dropTarget = new DropTarget(this, 3, this.getDTListener(), true);
        this.loadButtonsFromPrefs();
    }

    DropTargetListener getDTListener() {
        if (this.dtListener == null) {
            this.dtListener = new DTListener();
        }
        return this.dtListener;
    }

    private int getInsertionIndex(Point dropLocation) {
        int insertionIndex = this.getComponentCount();
        int closestComponentDistance = 10000;
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            int distanceAway;
            if (components[i].getBounds().contains(dropLocation)) {
                insertionIndex = i + 1;
                break;
            }
            Rectangle componentBounds = components[i].getBounds();
            int rightSideOfComponent = componentBounds.x + componentBounds.width;
            if (dropLocation.y > componentBounds.y + componentBounds.height || dropLocation.y < componentBounds.y || Math.abs(distanceAway = dropLocation.x - rightSideOfComponent) >= Math.abs(closestComponentDistance)) continue;
            closestComponentDistance = distanceAway;
            int rightOrLeft = distanceAway > 0 ? 1 : -1;
            insertionIndex = i + rightOrLeft;
            insertionIndex = insertionIndex < 0 ? 0 : insertionIndex;
        }
        return insertionIndex;
    }

    private void loadButtonsFromPrefs() {
        try {
            Vector<ButtonNode> buttonNodes = new Vector<ButtonNode>();
            for (String nodeName : this.tabPreferences.childrenNames()) {
                Preferences buttonPreferences = this.tabPreferences.node(nodeName);
                String conceptName = buttonPreferences.get(PREF_BUTTON_NAME, "unknown");
                int order = buttonPreferences.getInt(PREF_BUTTON_ORDER, 0);
                NewObservationUsingConceptNameButton button = new NewObservationUsingConceptNameButton(conceptName, this.toolbelt);
                this.makeButtonDeletable((JButton)((Object)button));
                ButtonNode buttonNode = new ButtonNode(nodeName, order, conceptName, (JButton)((Object)button));
                buttonNodes.add(buttonNode);
            }
            Collections.sort(buttonNodes, new Comparator<ButtonNode>(){

                @Override
                public int compare(ButtonNode o1, ButtonNode o2) {
                    return o1.order - o2.order;
                }
            });
            for (int i = 0; i < buttonNodes.size(); ++i) {
                ButtonNode buttonNode = (ButtonNode)buttonNodes.get(i);
                Preferences preferences = this.tabPreferences.node(buttonNode.conceptName);
                preferences.putInt(PREF_BUTTON_ORDER, i);
                this.add(buttonNode.button);
            }
        }
        catch (Exception e) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
        }
    }

    private void makeButtonDeletable(final JButton button) {
        if (button instanceof IPopup) {
            JPopupMenu popup = ((IPopup)button).getPopupMenu();
            JMenuItem delete = new JMenuItem("Delete");
            delete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ConceptButtonDropPanel.this.remove(button);
                    ConceptButtonDropPanel.this.repaint();
                    try {
                        ConceptButtonDropPanel.this.tabPreferences.node(button.getText()).removeNode();
                    }
                    catch (BackingStoreException e) {
                        ConceptButtonDropPanel.this.log.warn("Unable to update preferences. Reason: " + e.getClass().getName() + " -> " + e.getMessage());
                    }
                }
            });
            popup.add(delete);
        } else {
            this.log.warn("Attempted to add a Button that does not implemement the IPopup interface");
        }
    }

    private void saveButtonPositionPreferences() {
        Component[] buttons = this.getComponents();
        for (int i = 0; i < buttons.length; ++i) {
            if (!(buttons[i] instanceof NewObservationUsingConceptNameButton)) continue;
            String nodeName = ((NewObservationUsingConceptNameButton)((Object)buttons[i])).getConceptName();
            Preferences preferences = this.tabPreferences.node(nodeName);
            preferences.putInt(PREF_BUTTON_ORDER, i);
            preferences.put(PREF_BUTTON_NAME, nodeName);
        }
    }

    class DTListener
    implements DropTargetListener {
        DTListener() {
        }

        private DataFlavor chooseDropFlavor(DropTargetDropEvent e) {
            if (e.isLocalTransfer() && e.isDataFlavorSupported(StringTransferable.LOCAL_STRING_FLAVOR)) {
                return StringTransferable.LOCAL_STRING_FLAVOR;
            }
            DataFlavor chosen = null;
            if (e.isDataFlavorSupported(StringTransferable.LOCAL_STRING_FLAVOR)) {
                chosen = StringTransferable.LOCAL_STRING_FLAVOR;
            }
            if (e.isDataFlavorSupported(NewObservationUsingConceptNameButton.BUTTON_FLAVOR)) {
                chosen = NewObservationUsingConceptNameButton.BUTTON_FLAVOR;
            }
            return chosen;
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            if (!this.isDragOk(e)) {
                e.rejectDrag();
                return;
            }
            e.acceptDrag(e.getDropAction());
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            if (!this.isDragOk(e)) {
                e.rejectDrag();
                return;
            }
            e.acceptDrag(e.getDropAction());
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            DataFlavor chosen = this.chooseDropFlavor(e);
            if (chosen == null) {
                ConceptButtonDropPanel.this.log.warn("No flavor match found");
                e.rejectDrop();
                return;
            }
            int sa = e.getSourceActions();
            if ((sa & 3) == 0) {
                e.rejectDrop();
                return;
            }
            Object data = null;
            try {
                e.acceptDrop(3);
                data = e.getTransferable().getTransferData(chosen);
                if (data == null) {
                    throw new NullPointerException();
                }
            }
            catch (Throwable t) {
                ConceptButtonDropPanel.this.log.warn("Unable to accept drag and dropped info.", t);
                e.dropComplete(false);
                return;
            }
            NewObservationUsingConceptNameButton buttonToDrop = null;
            if (data instanceof String) {
                String s = (String)data;
                Component[] components = ConceptButtonDropPanel.this.getComponents();
                for (int i = 0; i < components.length; ++i) {
                    if (!(components[i] instanceof JButton) || !((JButton)components[i]).getText().equals(s)) continue;
                    JButton existingButton = (JButton)components[i];
                    SwingUtils.flashJComponent((JComponent)existingButton, (int)2);
                    return;
                }
                buttonToDrop = new NewObservationUsingConceptNameButton(s, ConceptButtonDropPanel.this.toolbelt);
                ConceptButtonDropPanel.this.makeButtonDeletable((JButton)((Object)buttonToDrop));
            } else if (data instanceof NewObservationUsingConceptNameButton) {
                buttonToDrop = (NewObservationUsingConceptNameButton)data;
                ConceptButtonDropPanel.this.remove((Component)((Object)buttonToDrop));
            }
            if (buttonToDrop == null) {
                e.dropComplete(false);
                return;
            }
            Point dropLocation = e.getLocation();
            int index = ConceptButtonDropPanel.this.getInsertionIndex(dropLocation);
            ConceptButtonDropPanel.this.add((Component)((Object)buttonToDrop), index);
            ConceptButtonDropPanel.this.saveButtonPositionPreferences();
            e.dropComplete(true);
            ConceptButtonDropPanel.this.revalidate();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
            if (!this.isDragOk(e)) {
                e.rejectDrag();
                return;
            }
            e.acceptDrag(e.getDropAction());
        }

        private boolean isDragFlavorSupported(DropTargetDragEvent e) {
            boolean ok = false;
            if (e.isDataFlavorSupported(StringTransferable.LOCAL_STRING_FLAVOR)) {
                ok = true;
            }
            if (e.isDataFlavorSupported(NewObservationUsingConceptNameButton.BUTTON_FLAVOR)) {
                ok = true;
            }
            return ok;
        }

        private boolean isDragOk(DropTargetDragEvent e) {
            if (!this.isDragFlavorSupported(e)) {
                return false;
            }
            int da = e.getDropAction();
            return (da & 3) != 0;
        }
    }

    class ButtonNode {
        final JButton button;
        final String conceptName;
        final String nodeName;
        final int order;

        public ButtonNode(String nodeName, int order, String conceptName, JButton button) {
            this.nodeName = nodeName;
            this.order = order;
            this.conceptName = conceptName;
            this.button = button;
        }
    }
}

