/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.buttons;

import java.awt.Component;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import vars.annotation.Observation;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.buttons.PropButton;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.impl.EditNotesCmd;
import vars.annotation.ui.dialogs.AddCommentAssociationDialog;

public class PNotesButton
extends PropButton {
    private ActionAdapter showDialogAction;

    public PNotesButton() {
        this.setAction((Action)this.getShowDialogAction());
        this.setToolTipText("edit notes");
        this.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/vars/annotation/note.png")));
        this.setEnabled(false);
    }

    protected ActionAdapter getShowDialogAction() {
        if (this.showDialogAction == null) {
            this.showDialogAction = new ShowDialogAction();
        }
        return this.showDialogAction;
    }

    private class ShowDialogAction
    extends ActionAdapter {
        private AddCommentAssociationDialog dialog;

        private ShowDialogAction() {
        }

        public void doAction() {
            AddCommentAssociationDialog d = this.getDialog();
            Collection<Observation> observations = StateLookup.getSelectedObservations();
            if (observations.size() == 1) {
                Observation obs = observations.iterator().next();
                String notes = obs.getNotes();
                String note = notes != null ? notes : "";
                d.setComment(note);
                d.setVisible(true);
            }
        }

        protected AddCommentAssociationDialog getDialog() {
            if (this.dialog == null) {
                this.dialog = new AddCommentAssociationDialog();
                this.dialog.setLocationRelativeTo((Component)((Object)PNotesButton.this));
                this.dialog.getOkayButton().addActionListener(e -> {
                    EditNotesCmd command = null;
                    Collection<Observation> observations = StateLookup.getSelectedObservations();
                    if (observations.size() == 1) {
                        Observation obs = observations.iterator().next();
                        String oldNotes = obs.getNotes();
                        String newNotes = this.dialog.getComment();
                        Long id = (Long)obs.getPrimaryKey();
                        command = new EditNotesCmd(newNotes, oldNotes, id);
                    }
                    this.dialog.setVisible(false);
                    if (command != null) {
                        CommandEvent commandEvent = new CommandEvent(command);
                        EventBus.publish((Object)commandEvent);
                    }
                });
            }
            return this.dialog;
        }
    }
}

