/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.buttons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.ui.actions.AddNewRefNumPropAction;
import vars.annotation.ui.eventbus.VideoArchiveChangedEvent;
import vars.annotation.ui.eventbus.VideoArchiveSelectedEvent;

public class PNewRefNumButtonController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private AnnotationDAOFactory annotationDAOFactory;

    public PNewRefNumButtonController(AnnotationDAOFactory annotationDAOFactory) {
        this.annotationDAOFactory = annotationDAOFactory;
        AnnotationProcessor.process((Object)this);
    }

    public Collection<Integer> listReferenceNumbers(VideoArchive videoArchive) {
        VideoArchiveDAO videoArchiveDAO = this.annotationDAOFactory.newVideoArchiveDAO();
        Set refNums = videoArchiveDAO.findAllLinkValues(videoArchive, "identity-reference");
        ArrayList<Integer> refInts = new ArrayList<Integer>(refNums.size());
        for (String object : refNums) {
            try {
                refInts.add(Integer.valueOf(object));
            }
            catch (Exception e) {
                this.log.warn(object + " is not an integer. Unable to parse identity-reference");
            }
        }
        return refInts;
    }

    public Integer findMaxReferenceNumber(VideoArchive videoArchive) {
        Collection<Integer> refNums = this.listReferenceNumbers(videoArchive);
        Integer max = null;
        try {
            max = Collections.max(refNums);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return max;
    }

    @EventSubscriber(eventClass=VideoArchiveSelectedEvent.class)
    public void respondTo(VideoArchiveSelectedEvent event) {
        this.respondTo(new VideoArchiveChangedEvent((Object)this, (VideoArchive)event.get()));
    }

    @EventSubscriber(eventClass=VideoArchiveChangedEvent.class)
    public void respondTo(VideoArchiveChangedEvent event) {
        Integer max = this.findMaxReferenceNumber((VideoArchive)event.get());
        int maxInt = max == null ? 1 : max + 1;
        AddNewRefNumPropAction.setRefNumber(maxInt);
    }
}

