/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.buttons;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.mbari.swing.IPopup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.VideoArchive;
import vars.annotation.ui.AnnotationFrame;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.actions.AddNewRefNumPropAction;
import vars.annotation.ui.buttons.PNewRefNumButtonController;
import vars.annotation.ui.buttons.PropButton;
import vars.annotation.ui.eventbus.VideoArchiveSelectedEvent;

public class PNewRefNumButton
extends PropButton
implements IPopup {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private JPopupMenu jPopupMenu;
    private final ToolBelt toolBelt = PNewRefNumButton.getToolBelt();
    private final PNewRefNumButtonController controller = new PNewRefNumButtonController(this.toolBelt.getAnnotationDAOFactory());

    public PNewRefNumButton() {
        this.setAction((Action)((Object)new AddNewRefNumPropAction(this.toolBelt)));
        this.initialize();
    }

    private JPopupMenu getJPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = new JPopupMenu();
            JMenuItem auto = new JMenuItem("Set to maximum reference number + 1");
            auto.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchive videoArchive = StateLookup.getVideoArchive();
                    PNewRefNumButton.this.controller.respondTo(new VideoArchiveSelectedEvent((Object)PNewRefNumButton.this, videoArchive));
                }
            });
            this.jPopupMenu.add(auto);
            JMenuItem reset = new JMenuItem("Reset to one");
            reset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    AddNewRefNumPropAction.setRefNumber(1);
                }
            });
            this.jPopupMenu.add(reset);
            JMenuItem set = new JMenuItem("Set value");
            set.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    VideoArchive videoArchive = StateLookup.getVideoArchive();
                    Integer max = PNewRefNumButton.this.controller.findMaxReferenceNumber(videoArchive);
                    String maxString = max == null ? "1" : max.toString();
                    AnnotationFrame frame = StateLookup.getAnnotationFrame();
                    String s = (String)JOptionPane.showInputDialog(frame, "Enter a reference number", "VARS - Input", -1, null, null, maxString);
                    if (s != null) {
                        try {
                            AddNewRefNumPropAction.setRefNumber(Integer.parseInt(s));
                        }
                        catch (Exception e) {
                            PNewRefNumButton.this.log.info("We have a failure to communicate. Unable to parse " + s + " as an integer");
                            this.actionPerformed(ae);
                        }
                    }
                }
            });
            this.jPopupMenu.add(set);
        }
        return this.jPopupMenu;
    }

    public JPopupMenu getPopupMenu() {
        return this.getJPopupMenu();
    }

    private void initialize() {
        this.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/vars/annotation/newnum.png")));
        this.setToolTipText("reference #");
        this.setEnabled(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PNewRefNumButton.this.getJPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }
}

